/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.discrepancy.Searcher;
import umontreal.ssj.hups.Rank1Lattice;
import umontreal.ssj.util.Num;

public class SearcherCBC
extends Searcher {
    protected double[] bestVals;

    private double exhaust(int s, boolean relPrime) {
        int n = this.disc.getNumPoints();
        this.gamma = this.disc.getGamma();
        int pos = -1;
        double best = 0.0;
        this.bestAs[0] = 1;
        this.bestVals[0] = -1.0;
        for (int j = 1; j < s; ++j) {
            best = Double.MAX_VALUE;
            pos = -1;
            for (int i = 1; i < n; ++i) {
                if (relPrime && (this.power2F ? (i & 1) == 0 : Num.gcd(n, i) != 1)) continue;
                this.bestAs[j] = i;
                this.lat = new Rank1Lattice(n, this.bestAs, j + 1);
                double err = this.disc.compute(this.lat, this.gamma);
                if (!(err < best)) continue;
                best = err;
                pos = i;
            }
            this.bestAs[j] = pos;
            this.bestVals[j] = best;
        }
        this.bestVal = best;
        return best;
    }

    private double random(int s, int k, boolean relPrime) {
        int n = this.disc.getNumPoints();
        if (k >= n) {
            return this.exhaust(s, relPrime);
        }
        this.gamma = this.disc.getGamma();
        int nm1 = n - 1;
        int pos = -1;
        double best = 0.0;
        this.bestAs[0] = 1;
        this.bestVals[0] = -1.0;
        for (int j = 1; j < s; ++j) {
            best = Double.MAX_VALUE;
            for (int i = 0; i < k; ++i) {
                if (this.power2F) {
                    this.bestAs[j] = gen.nextInt(1, nm1);
                    if (relPrime) {
                        int n2 = j;
                        this.bestAs[n2] = this.bestAs[n2] | 1;
                    }
                } else {
                    do {
                        this.bestAs[j] = gen.nextInt(1, nm1);
                    } while (relPrime && Num.gcd(n, this.bestAs[j]) != 1);
                }
                this.lat = new Rank1Lattice(n, this.bestAs, j + 1);
                double err = this.disc.compute(this.lat, this.gamma);
                if (!(err < best)) continue;
                best = err;
                pos = this.bestAs[j];
            }
            this.bestAs[j] = pos;
            this.bestVals[j] = best;
        }
        this.bestVal = best;
        return best;
    }

    public SearcherCBC(Discrepancy disc, boolean primeN) {
        super(disc, primeN);
        int s = disc.getDimension();
        this.bestVals = new double[s];
    }

    @Override
    public double exhaust(int s) {
        return this.exhaust(s, false);
    }

    @Override
    public double exhaustPrime(int s) {
        if (this.primeN) {
            return this.exhaust(s, false);
        }
        return this.exhaust(s, true);
    }

    @Override
    public double random(int s, int k) {
        return this.random(s, k, false);
    }

    @Override
    public double randomPrime(int s, int k) {
        if (this.primeN) {
            return this.random(s, k, false);
        }
        return this.random(s, k, true);
    }

    public double[] getBestVals() {
        return this.bestVals;
    }
}

