/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.functionfit;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import java.io.Serializable;
import umontreal.ssj.functions.Polynomial;
import umontreal.ssj.util.PrintfFormat;

public class PolInterp
extends Polynomial
implements Serializable {
    private static final long serialVersionUID = -710451931485296501L;
    private static final Algebra alg = new Algebra();
    private double[] x;
    private double[] y;

    public PolInterp(double[] x, double[] y) {
        super(PolInterp.getCoefficients(x, y));
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
    }

    public static double[] getCoefficients(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must have the same length");
        }
        if (x.length <= 1) {
            throw new IllegalArgumentException("At least two points are needed");
        }
        DenseDoubleMatrix2D u = new DenseDoubleMatrix2D(x.length, x.length);
        for (int i = 0; i < x.length; ++i) {
            double v = 1.0;
            for (int j = 0; j < x.length; ++j) {
                ((DoubleMatrix2D)u).setQuick(i, j, v);
                v *= x[i];
            }
        }
        DenseDoubleMatrix2D yMat = new DenseDoubleMatrix2D(x.length, 1);
        yMat.viewColumn(0).assign(y);
        DoubleMatrix2D bMat = alg.solve(u, yMat);
        return bMat.viewColumn(0).toArray();
    }

    public double[] getX() {
        return (double[])this.x.clone();
    }

    public double[] getY() {
        return (double[])this.y.clone();
    }

    public static String toString(double[] x, double[] y) {
        StringBuilder sb = new StringBuilder("Points: ");
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            String xstr = PrintfFormat.format(8, 3, 3, x[i]);
            String ystr = PrintfFormat.format(8, 3, 3, y[i]);
            sb.append('(').append(xstr).append(", ").append(ystr).append(')');
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return PolInterp.toString(this.x, this.y);
    }

    @Override
    public PolInterp clone() {
        PolInterp p = (PolInterp)super.clone();
        p.x = (double[])this.x.clone();
        p.y = (double[])this.y.clone();
        return p;
    }
}

