/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import cern.colt.list.IntArrayList;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import umontreal.ssj.hups.CycleBasedPointSetBase2;
import umontreal.ssj.hups.F2wStructure;
import umontreal.ssj.util.PrintfFormat;

public class CycleBasedLFSR
extends CycleBasedPointSetBase2 {
    private int J = 1;
    private int k1 = 0;
    private int k2 = 0;
    private int step1;
    private int step2;
    private int nbcoeff1;
    private int nbcoeff2;
    private int[] nocoeff1;
    private int[] nocoeff2;
    private int[] posa1;
    private int[] posa2;
    private int[] shifta1;
    private int[] shifta2;
    private int x1 = 0;
    private int x2 = 0;
    private int state = 0;
    private int value = 0;
    private int maskX;
    private int maskX1;
    private int maskX2;
    private int maskX1Shift;

    public CycleBasedLFSR(int step1, int nbcoeff1, int[] nocoeff1) {
        this.step1 = step1;
        this.nbcoeff1 = nbcoeff1 - 1;
        this.nocoeff1 = nocoeff1;
        this.J = 1;
        this.init();
    }

    public CycleBasedLFSR(int step1, int step2, int nbcoeff1, int nbcoeff2, int[] nocoeff1, int[] nocoeff2) {
        this.step1 = step1;
        this.step2 = step2;
        this.nbcoeff1 = nbcoeff1 - 1;
        this.nbcoeff2 = nbcoeff2 - 1;
        this.nocoeff1 = nocoeff1;
        this.nocoeff2 = nocoeff2;
        this.J = 2;
        this.init();
    }

    public CycleBasedLFSR(String filename, int no) {
        this.readFile(filename, no);
        this.init();
    }

    private void init() {
        int i;
        this.k1 = this.nocoeff1[0];
        this.posa1 = new int[this.nbcoeff1];
        this.shifta1 = new int[this.nbcoeff1];
        for (i = 0; i < this.nbcoeff1; ++i) {
            this.posa1[i] = this.k1 - this.nocoeff1[i + 1] - 1;
            this.shifta1[i] = 1 << this.posa1[i];
        }
        if (this.J == 2) {
            this.k2 = this.nocoeff2[0];
            this.posa2 = new int[this.nbcoeff2];
            this.shifta2 = new int[this.nbcoeff2];
            for (i = 0; i < this.nbcoeff2; ++i) {
                this.posa2[i] = this.k2 - this.nocoeff2[i + 1] - 1;
                this.shifta2[i] = 1 << this.posa2[i];
            }
        }
        if (this.k1 + this.k2 > 31) {
            System.err.println("The degree of the combined polynomials must be < 31");
            System.err.println("k1 = " + this.k1 + " k2 = " + this.k2);
            System.exit(1);
        }
        this.maskX1 = (1 << this.k1) - 1;
        this.maskX2 = (1 << this.k2) - 1;
        this.maskX1Shift = this.maskX1 << this.k2;
        this.maskX = (1 << this.k1 + this.k2) - 1;
        this.numBits = this.k1 + this.k2;
        this.normFactor = 1.0 / (double)(1L << this.numBits);
        this.fillCyclesLFSR();
    }

    @Override
    public String toString() {
        int i;
        String s = "CycleBasedLFSR:" + PrintfFormat.NEWLINE + "First  Polynome:  Step: " + this.step1 + "  Coefficients: ";
        for (i = 0; i < this.nbcoeff1; ++i) {
            s = s + this.nocoeff1[i] + ", ";
        }
        s = s + this.nocoeff1[i];
        if (this.J == 1) {
            return s;
        }
        s = s + PrintfFormat.NEWLINE + "Second Polynome:  Step: " + this.step2 + "  Coefficients: ";
        for (i = 0; i < this.nbcoeff2; ++i) {
            s = s + this.nocoeff2[i] + ", ";
        }
        s = s + this.nocoeff2[i];
        return s;
    }

    private void nextState() {
        int i;
        int b = 0;
        int s = 0;
        for (s = 0; s < this.step1; ++s) {
            b = 0;
            for (i = 0; i < this.nbcoeff1; ++i) {
                b ^= (this.x1 & this.shifta1[i]) >> this.posa1[i];
            }
            this.x1 <<= 1;
            this.x1 |= b;
        }
        if (this.J == 1) {
            this.value = this.state = this.x1 & this.maskX1;
            return;
        }
        for (s = 0; s < this.step2; ++s) {
            b = 0;
            for (i = 0; i < this.nbcoeff2; ++i) {
                b ^= (this.x2 & this.shifta2[i]) >> this.posa2[i];
            }
            this.x2 <<= 1;
            this.x2 |= b;
        }
        this.value = (this.x1 ^ this.x2) & this.maskX;
        this.state = this.x1 & this.maskX1Shift | this.x2 >>> this.k1 & this.maskX2;
    }

    private void validateState(int x1x2) {
        int i;
        int b = 0;
        int s = 0;
        this.x1 = x1x2 >> this.k2;
        for (s = 0; s < this.k2; ++s) {
            b = 0;
            for (i = 0; i < this.nbcoeff1; ++i) {
                b ^= (this.x1 & this.shifta1[i]) >> this.posa1[i];
            }
            this.x1 <<= 1;
            this.x1 |= b;
        }
        if (this.J == 1) {
            this.value = this.state = this.x1 & this.maskX1;
            return;
        }
        this.x2 = x1x2 & this.maskX2;
        for (s = 0; s < this.k1; ++s) {
            b = 0;
            for (i = 0; i < this.nbcoeff2; ++i) {
                b ^= (this.x2 & this.shifta2[i]) >> this.posa2[i];
            }
            this.x2 <<= 1;
            this.x2 |= b;
        }
        this.value = (this.x1 ^ this.x2) & this.maskX;
    }

    private void fillCyclesLFSR() {
        int i;
        int n = 1 << this.k1 + this.k2;
        boolean[] stateVisited = new boolean[n];
        for (i = 0; i < n; ++i) {
            stateVisited[i] = false;
        }
        int startState = 0;
        this.numPoints = 0;
        while (startState < n) {
            stateVisited[startState] = true;
            IntArrayList c = new IntArrayList();
            c.add(this.value);
            this.nextState();
            while (this.state != startState) {
                stateVisited[this.state] = true;
                c.add(this.value);
                this.nextState();
            }
            this.addCycle(c);
            for (i = startState + 1; i < n && stateVisited[i]; ++i) {
            }
            startState = i;
            this.validateState(i);
        }
    }

    private void readFile(String fileName, int no) {
        BufferedReader input = null;
        try {
            if (new File(fileName).exists()) {
                input = new BufferedReader(new FileReader(fileName));
            } else {
                DataInputStream dataInput = new DataInputStream(F2wStructure.class.getClassLoader().getResourceAsStream("umontreal/ssj/hups/dataLFSR/" + fileName));
                input = new BufferedReader(new InputStreamReader(dataInput));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + fileName + " not found" + PrintfFormat.NEWLINE);
            System.exit(1);
        }
        if (no < 1) {
            no = 1;
        }
        String line = this.readOneLine(input);
        int[] numbers = this.lineToNumbers(line);
        this.J = numbers[0];
        if (this.J != 1 && this.J != 2) {
            System.err.println("Error: J = " + this.J + PrintfFormat.NEWLINE + "CycleBasedLFSR works only for the cases of one or two polynomials");
            System.exit(1);
        }
        int nbLines = (this.J + 1) * (no - 1);
        for (int i = 0; i < nbLines; ++i) {
            line = this.readOneLine(input);
            if (line != null) continue;
            System.err.println("Error CycleBasedLFSR:" + PrintfFormat.NEWLINE + " no data in file " + fileName + " for " + no + "-th LFSR");
            System.exit(1);
        }
        line = this.readOneLine(input);
        if (line == null) {
            System.err.println("Error CycleBasedLFSR:" + PrintfFormat.NEWLINE + " no data in file " + fileName + " for " + no + "-th LFSR");
            System.exit(1);
        }
        numbers = this.lineToNumbers(line);
        if (this.J == 1) {
            this.step1 = numbers[0];
            line = this.readOneLine(input);
            this.nocoeff1 = this.lineToNumbers(line);
            this.nbcoeff1 = this.nocoeff1.length - 1;
        } else if (this.J == 2) {
            this.step1 = numbers[0];
            this.step2 = numbers[1];
            line = this.readOneLine(input);
            this.nocoeff1 = this.lineToNumbers(line);
            this.nbcoeff1 = this.nocoeff1.length - 1;
            line = this.readOneLine(input);
            this.nocoeff2 = this.lineToNumbers(line);
            this.nbcoeff2 = this.nocoeff2.length - 1;
        }
    }

    private String readOneLine(BufferedReader input) {
        try {
            String line;
            while (true) {
                if ((line = input.readLine()) == null) {
                    return null;
                }
                if ((line = line.trim()).length() == 0) {
                    line = input.readLine();
                    continue;
                }
                if (line.charAt(0) != '#') break;
                line = input.readLine();
            }
            int index = line.indexOf(35);
            if (index >= 0) {
                line = line.substring(0, index).trim();
            }
            return line;
        }
        catch (IOException e) {
            System.err.println(e);
            System.exit(1);
            return null;
        }
    }

    private int[] lineToNumbers(String line) {
        String[] snumbers = line.split("\\s++");
        int nb = snumbers.length;
        int[] numbers = new int[nb];
        for (int i = 0; i < nb; ++i) {
            numbers[i] = Integer.valueOf(snumbers[i]);
        }
        return numbers;
    }
}

