/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.probdist.ChiSquareDist;
import umontreal.ssj.probdist.GammaDist;
import umontreal.ssj.probdist.NormalDist;

public class ChiSquareDistQuick
extends ChiSquareDist {
    public ChiSquareDistQuick(int n) {
        super(n);
    }

    @Override
    public double inverseF(double u) {
        return ChiSquareDistQuick.inverseF(this.n, u);
    }

    public static double inverseF(int n, double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double SQP5 = 0.7071067811865476;
        double DWARF = 1.0E-16;
        double ULOW = 0.02;
        if (n == 1) {
            double Z = NormalDist.inverseF01((1.0 + u) / 2.0);
            return Z * Z;
        }
        if (n == 2) {
            double arg = 1.0 - u;
            if (arg < 1.0E-16) {
                arg = 1.0E-16;
            }
            return -Math.log(arg) * 2.0;
        }
        if (u > 0.02 && u < 0.98) {
            double Z = NormalDist.inverseF01(u);
            double sqdf = Math.sqrt(n);
            double v = Z * Z;
            double ch = -(((3753.0 * v + 4353.0) * v - 289517.0) * v - 289717.0) * Z * 0.7071067811865476 / 9185400.0;
            ch = ch / sqdf + (((12.0 * v - 243.0) * v - 923.0) * v + 1472.0) / 25515.0;
            ch = ch / sqdf + ((9.0 * v + 256.0) * v - 433.0) * Z * 0.7071067811865476 / 4860.0;
            ch = ch / sqdf - ((6.0 * v + 14.0) * v - 32.0) / 405.0;
            ch = ch / sqdf + (v - 7.0) * Z * 0.7071067811865476 / 9.0;
            ch = ch / sqdf + 2.0 * (v - 1.0) / 3.0;
            ch = ch / sqdf + Z / 0.7071067811865476;
            return (double)n * (ch / sqdf + 1.0);
        }
        if (n >= 10) {
            double Z = NormalDist.inverseF01(u);
            double v = Z * Z;
            double temp = 0.3333333333333333 + (-v + 3.0) / (162.0 * (double)n) - (3.0 * v * v + 40.0 * v + 45.0) / (5832.0 * (double)n * (double)n) + (301.0 * v * v * v - 1519.0 * v * v - 32769.0 * v - 79349.0) / (7873200.0 * (double)n * (double)n * (double)n);
            double ch = 1.0 - 2.0 / (9.0 * (double)n) + (4.0 * v * v + 16.0 * v - 28.0) / (1215.0 * (double)n * (double)n) + (8.0 * v * v * v + 720.0 * v * v + 3216.0 * v + 2904.0) / (229635.0 * (double)n * (double)n * (double)n) + (temp *= Z * Math.sqrt(2.0 / (double)n));
            return (double)n * ch * ch * ch;
        }
        return 2.0 * GammaDist.inverseF((double)n / 2.0, 6, u);
    }
}

