/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.probdist.DiscreteDistribution;
import umontreal.ssj.probdist.DiscreteDistributionInt;
import umontreal.ssj.probdist.Distribution;

public class DistributionFactory {
    private DistributionFactory() {
    }

    public static Distribution getDistribution(String str) {
        int parTo;
        int parFrom;
        Class<?> distClass;
        int i = 0;
        int idx = (str = str.trim()).indexOf(40, i);
        String distName = idx == -1 ? str.substring(i).trim() : str.substring(i, idx).trim();
        if (distName.equals("String")) {
            throw new IllegalArgumentException("Invalid distribution name: " + distName);
        }
        try {
            distClass = Class.forName("umontreal.ssj.probdist." + distName);
        }
        catch (ClassNotFoundException e) {
            try {
                distClass = Class.forName(distName);
                if (!Distribution.class.isAssignableFrom(distClass)) {
                    throw new IllegalArgumentException("The given class is not a Probdist distribution class.");
                }
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Invalid distribution name: " + distName);
            }
        }
        String paramStr = "";
        if (idx != -1 && ((paramStr = str.substring((parFrom = idx) + 1, parTo = str.lastIndexOf(41)).trim()).indexOf(40) != -1 || paramStr.indexOf(41) != -1)) {
            throw new IllegalArgumentException("Invalid parameter string: " + paramStr);
        }
        if (paramStr.equals("")) {
            try {
                return (Distribution)distClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Default parameters not available");
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Default parameters not available");
            }
        }
        StringTokenizer paramTok = new StringTokenizer(paramStr, ",");
        int nparams = paramTok.countTokens();
        Constructor<?>[] cons = distClass.getConstructors();
        Constructor<?> distCons = null;
        Class<?>[] paramTypes = null;
        for (i = 0; i < cons.length; ++i) {
            if (!Modifier.isPublic(cons[i].getModifiers()) || (paramTypes = cons[i].getParameterTypes()).length != nparams) continue;
            distCons = cons[i];
            break;
        }
        if (distCons == null) {
            throw new IllegalArgumentException("Invalid parameter number");
        }
        Object[] instParams = new Object[nparams];
        for (i = 0; i < nparams; ++i) {
            String par = paramTok.nextToken().trim();
            try {
                if (paramTypes[i] == Integer.TYPE) {
                    instParams[i] = new Integer(par);
                    continue;
                }
                if (paramTypes[i] == Long.TYPE) {
                    instParams[i] = new Long(par);
                    continue;
                }
                if (paramTypes[i] == Float.TYPE) {
                    if (par.equalsIgnoreCase("infinity") || par.equalsIgnoreCase("+infinity")) {
                        instParams[i] = new Float(Float.POSITIVE_INFINITY);
                        continue;
                    }
                    if (par.equalsIgnoreCase("-infinity")) {
                        instParams[i] = new Float(Float.NEGATIVE_INFINITY);
                        continue;
                    }
                    instParams[i] = new Float(par);
                    continue;
                }
                if (paramTypes[i] == Double.TYPE) {
                    if (par.equalsIgnoreCase("infinity") || par.equalsIgnoreCase("+infinity")) {
                        instParams[i] = new Double(Double.POSITIVE_INFINITY);
                        continue;
                    }
                    if (par.equalsIgnoreCase("-infinity")) {
                        instParams[i] = new Double(Double.NEGATIVE_INFINITY);
                        continue;
                    }
                    instParams[i] = new Double(par);
                    continue;
                }
                throw new IllegalArgumentException("Parameter " + (i + 1) + " type " + paramTypes[i].getName() + "not supported");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Parameter " + (i + 1) + " of type " + paramTypes[i].getName() + " could not be converted from String");
            }
        }
        try {
            return (Distribution)distCons.newInstance(instParams);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static ContinuousDistribution getDistributionMLE(String distName, double[] x, int n) {
        Class<?> distClass;
        try {
            distClass = Class.forName("umontreal.ssj.probdist." + distName);
        }
        catch (ClassNotFoundException e) {
            try {
                distClass = Class.forName(distName);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Invalid distribution name: " + distName);
            }
        }
        return DistributionFactory.getDistributionMLE(distClass, x, n);
    }

    public static DiscreteDistributionInt getDistributionMLE(String distName, int[] x, int n) {
        Class<?> distClass;
        try {
            distClass = Class.forName("umontreal.ssj.probdist." + distName);
        }
        catch (ClassNotFoundException e) {
            try {
                distClass = Class.forName(distName);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Invalid distribution name: " + distName);
            }
        }
        return DistributionFactory.getDistributionMLE(distClass, x, n);
    }

    public static <T extends ContinuousDistribution> T getDistributionMLE(Class<T> distClass, double[] x, int n) {
        Method m;
        if (!ContinuousDistribution.class.isAssignableFrom(distClass)) {
            throw new IllegalArgumentException("The given class is not a Probdist distribution class.");
        }
        try {
            m = distClass.getMethod("getInstanceFromMLE", double[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The given class does not provide the static method getInstanceFromMLE (double[],int)");
        }
        if (!Modifier.isStatic(m.getModifiers()) || !distClass.isAssignableFrom(m.getReturnType())) {
            throw new IllegalArgumentException("The given class does not provide the static method getInstanceFromMLE (double[],int)");
        }
        try {
            return (T)((ContinuousDistribution)m.invoke(null, x, n));
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static <T extends DiscreteDistributionInt> T getDistributionMLE(Class<T> distClass, int[] x, int n) {
        Method m;
        if (!DiscreteDistributionInt.class.isAssignableFrom(distClass)) {
            throw new IllegalArgumentException("The given class is not a discrete distribution class over integers.");
        }
        try {
            m = distClass.getMethod("getInstanceFromMLE", int[].class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The given class does not provide the static method getInstanceFromMLE (int[],int)");
        }
        if (!Modifier.isStatic(m.getModifiers()) || !distClass.isAssignableFrom(m.getReturnType())) {
            throw new IllegalArgumentException("The given class does not provide the static method getInstanceFromMLE (int[],int)");
        }
        try {
            return (T)((DiscreteDistributionInt)m.invoke(null, x, n));
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static ContinuousDistribution getContinuousDistribution(String str) {
        return (ContinuousDistribution)DistributionFactory.getDistribution(str);
    }

    public static DiscreteDistribution getDiscreteDistribution(String str) {
        return (DiscreteDistribution)DistributionFactory.getDistribution(str);
    }

    public static DiscreteDistributionInt getDiscreteDistributionInt(String str) {
        return (DiscreteDistributionInt)DistributionFactory.getDistribution(str);
    }
}

