/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.probdist.DiscreteDistributionInt;

public class GeometricDist
extends DiscreteDistributionInt {
    private double p;
    private double vp;

    public GeometricDist(double p) {
        this.setP(p);
    }

    @Override
    public double prob(int x) {
        return GeometricDist.prob(this.p, x);
    }

    @Override
    public double cdf(int x) {
        return GeometricDist.cdf(this.p, x);
    }

    @Override
    public double barF(int x) {
        return GeometricDist.barF(this.p, x);
    }

    @Override
    public int inverseFInt(double u) {
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (this.p >= 1.0) {
            return 0;
        }
        if (u <= this.p) {
            return 0;
        }
        if (u >= 1.0 || this.p <= 0.0) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.floor(Math.log1p(-u) / this.vp);
    }

    @Override
    public double getMean() {
        return GeometricDist.getMean(this.p);
    }

    @Override
    public double getVariance() {
        return GeometricDist.getVariance(this.p);
    }

    @Override
    public double getStandardDeviation() {
        return GeometricDist.getStandardDeviation(this.p);
    }

    public static double prob(double p, int x) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range (0,1)");
        }
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return 0.0;
        }
        if (x < 0) {
            return 0.0;
        }
        return p * Math.pow(1.0 - p, x);
    }

    public static double cdf(double p, int x) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (x < 0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return 1.0;
        }
        if (p <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.pow(1.0 - p, (double)x + 1.0);
    }

    public static double barF(double p, int x) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (x < 0) {
            return 1.0;
        }
        if (p >= 1.0) {
            return 0.0;
        }
        if (p <= 0.0) {
            return 1.0;
        }
        return Math.pow(1.0 - p, x);
    }

    public static int inverseF(double p, double u) {
        if (p > 1.0 || p < 0.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (p >= 1.0) {
            return 0;
        }
        if (u <= p) {
            return 0;
        }
        if (u >= 1.0 || p <= 0.0) {
            return Integer.MAX_VALUE;
        }
        double v = Math.log1p(-p);
        return (int)Math.floor(Math.log1p(-u) / v);
    }

    public static double[] getMLE(int[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[1];
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += (double)x[i];
        }
        parameters[0] = 1.0 / (sum / (double)n + 1.0);
        return parameters;
    }

    public static GeometricDist getInstanceFromMLE(int[] x, int n) {
        double[] parameters = GeometricDist.getMLE(x, n);
        return new GeometricDist(parameters[0]);
    }

    public static double getMean(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range (0,1)");
        }
        return (1.0 - p) / p;
    }

    public static double getVariance(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range (0,1)");
        }
        return (1.0 - p) / (p * p);
    }

    public static double getStandardDeviation(double p) {
        return Math.sqrt(GeometricDist.getVariance(p));
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range (0,1)");
        }
        this.vp = Math.log1p(-p);
        this.p = p;
        this.supportA = 0;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.p};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : p = " + this.p;
    }
}

