/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.probdist.DiscreteDistributionInt;

public class UniformIntDist
extends DiscreteDistributionInt {
    protected int i;
    protected int j;

    public UniformIntDist(int i, int j) {
        this.setParams(i, j);
    }

    @Override
    public double prob(int x) {
        return UniformIntDist.prob(this.i, this.j, x);
    }

    @Override
    public double cdf(int x) {
        return UniformIntDist.cdf(this.i, this.j, x);
    }

    @Override
    public double barF(int x) {
        return UniformIntDist.barF(this.i, this.j, x);
    }

    @Override
    public int inverseFInt(double u) {
        return UniformIntDist.inverseF(this.i, this.j, u);
    }

    @Override
    public double getMean() {
        return UniformIntDist.getMean(this.i, this.j);
    }

    @Override
    public double getVariance() {
        return UniformIntDist.getVariance(this.i, this.j);
    }

    @Override
    public double getStandardDeviation() {
        return UniformIntDist.getStandardDeviation(this.i, this.j);
    }

    public static double prob(int i, int j, int x) {
        if (j < i) {
            throw new IllegalArgumentException("j < i");
        }
        if (x < i || x > j) {
            return 0.0;
        }
        return 1.0 / ((double)(j - i) + 1.0);
    }

    public static double cdf(int i, int j, int x) {
        if (j < i) {
            throw new IllegalArgumentException("j < i");
        }
        if (x < i) {
            return 0.0;
        }
        if (x >= j) {
            return 1.0;
        }
        return (double)(x - i + 1) / ((double)(j - i) + 1.0);
    }

    public static double barF(int i, int j, int x) {
        if (j < i) {
            throw new IllegalArgumentException("j < i");
        }
        if (x <= i) {
            return 1.0;
        }
        if (x > j) {
            return 0.0;
        }
        return ((double)(j - x) + 1.0) / ((double)(j - i) + 1.0);
    }

    public static int inverseF(int i, int j, double u) {
        if (j < i) {
            throw new IllegalArgumentException("j < i");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (u <= 0.0) {
            return i;
        }
        if (u >= 1.0) {
            return j;
        }
        return i + (int)(u * ((double)(j - i) + 1.0));
    }

    public static double[] getMLE(int[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[]{2.147483647E9, -2.147483648E9};
        for (int i = 0; i < n; ++i) {
            if ((double)x[i] < parameters[0]) {
                parameters[0] = x[i];
            }
            if (!((double)x[i] > parameters[1])) continue;
            parameters[1] = x[i];
        }
        return parameters;
    }

    public static UniformIntDist getInstanceFromMLE(int[] x, int n) {
        double[] parameters = UniformIntDist.getMLE(x, n);
        return new UniformIntDist((int)parameters[0], (int)parameters[1]);
    }

    public static double getMean(int i, int j) {
        if (j < i) {
            throw new IllegalArgumentException("j < i");
        }
        return (double)(i + j) / 2.0;
    }

    public static double getVariance(int i, int j) {
        if (j < i) {
            throw new IllegalArgumentException("j < i");
        }
        return (((double)(j - i) + 1.0) * ((double)(j - i) + 1.0) - 1.0) / 12.0;
    }

    public static double getStandardDeviation(int i, int j) {
        return Math.sqrt(UniformIntDist.getVariance(i, j));
    }

    public int getI() {
        return this.i;
    }

    public int getJ() {
        return this.j;
    }

    public void setParams(int i, int j) {
        if (j < i) {
            throw new IllegalArgumentException("j < i");
        }
        this.supportA = this.i = i;
        this.supportB = this.j = j;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.i, this.j};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : i = " + this.i + ", j = " + this.j;
    }
}

