/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import cern.jet.stat.Gamma;
import umontreal.ssj.probdist.GammaDist;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.GammaGen;
import umontreal.ssj.rng.RandomStream;

public class GammaAcceptanceRejectionGen
extends GammaGen {
    private RandomStream auxStream;
    private static final double q1 = 0.0416666664;
    private static final double q2 = 0.0208333723;
    private static final double q3 = 0.0079849875;
    private static final double q4 = 0.0015746717;
    private static final double q5 = -3.349403E-4;
    private static final double q6 = 3.340332E-4;
    private static final double q7 = 6.053049E-4;
    private static final double q8 = -4.701849E-4;
    private static final double q9 = 1.71032E-4;
    private static final double a1 = 0.333333333;
    private static final double a2 = -0.249999949;
    private static final double a3 = 0.199999867;
    private static final double a4 = -0.166677482;
    private static final double a5 = 0.142873973;
    private static final double a6 = -0.124385581;
    private static final double a7 = 0.11036831;
    private static final double a8 = -0.112750886;
    private static final double a9 = 0.104089866;
    private static final double e1 = 1.0;
    private static final double e2 = 0.499999994;
    private static final double e3 = 0.166666848;
    private static final double e4 = 0.041664508;
    private static final double e5 = 0.008345522;
    private static final double e6 = 0.001353826;
    private static final double e7 = 2.47453E-4;
    private int gen;
    private double beta;
    private double gamma;
    private static final int gs = 0;
    private static final int gd = 1;
    private double b;
    private double ss;
    private double s;
    private double d;
    private double r;
    private double q0;
    private double c;
    private double si;
    private static final double USE_LMS_THRESHOLD = 0.1;

    public GammaAcceptanceRejectionGen(RandomStream s, RandomStream aux, double alpha, double lambda) {
        super(s, null);
        this.auxStream = aux;
        this.setParams(alpha, lambda);
        this.beta = 1.0 / lambda;
        this.gamma = 0.0;
        this.init();
    }

    public GammaAcceptanceRejectionGen(RandomStream s, double alpha, double lambda) {
        this(s, s, alpha, lambda);
    }

    public GammaAcceptanceRejectionGen(RandomStream s, RandomStream aux, GammaDist dist) {
        super(s, dist);
        this.auxStream = aux;
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getLambda());
        }
        this.beta = 1.0 / dist.getLambda();
        this.gamma = 0.0;
        this.init();
    }

    public GammaAcceptanceRejectionGen(RandomStream s, GammaDist dist) {
        this(s, s, dist);
    }

    public RandomStream getAuxStream() {
        return this.auxStream;
    }

    public static double nextDouble(RandomStream s, RandomStream aux, double alpha, double lambda) {
        int gen = 0;
        double s_ = 0.0;
        double ss = 0.0;
        double d = 0.0;
        double q0 = 0.0;
        double r = 0.0;
        double c = 0.0;
        double si = 0.0;
        double b = 0.0;
        if (alpha < 0.1) {
            return GammaAcceptanceRejectionGen.acceptanceRejectionLms(s, aux, alpha, 1.0 / lambda);
        }
        if (alpha < 1.0) {
            gen = 0;
            b = 1.0 + 0.36788794412 * alpha;
        } else {
            gen = 1;
            ss = alpha - 0.5;
            s_ = Math.sqrt(ss);
            d = 5.656854249 - 12.0 * s_;
            r = 1.0 / alpha;
            q0 = ((((((((1.71032E-4 * r + -4.701849E-4) * r + 6.053049E-4) * r + 3.340332E-4) * r + -3.349403E-4) * r + 0.0015746717) * r + 0.0079849875) * r + 0.0208333723) * r + 0.0416666664) * r;
            if (alpha > 3.686) {
                if (alpha > 13.022) {
                    b = 1.77;
                    si = 0.75;
                    c = 0.1515 / s_;
                } else {
                    b = 1.654 + 0.0076 * ss;
                    si = 1.68 / s_ + 0.275;
                    c = 0.062 / s_ + 0.024;
                }
            } else {
                b = 0.463 + s_ - 0.178 * ss;
                si = 1.235;
                c = 0.195 / s_ - 0.079 + 0.016 * s_;
            }
        }
        return GammaAcceptanceRejectionGen.acceptanceRejection(s, aux, alpha, 1.0 / lambda, 0.0, gen, b, s_, ss, d, r, q0, c, si);
    }

    @Override
    public double nextDouble() {
        if (this.alpha < 0.1) {
            return GammaAcceptanceRejectionGen.acceptanceRejectionLms(this.stream, this.auxStream, this.alpha, this.beta);
        }
        return GammaAcceptanceRejectionGen.acceptanceRejection(this.stream, this.auxStream, this.alpha, this.beta, this.gamma, this.gen, this.b, this.s, this.ss, this.d, this.r, this.q0, this.c, this.si);
    }

    public static double nextDouble(RandomStream s, double alpha, double lambda) {
        return GammaAcceptanceRejectionGen.nextDouble(s, s, alpha, lambda);
    }

    public double nextDoubleLog() {
        if (this.alpha < 0.1) {
            return GammaAcceptanceRejectionGen.acceptanceRejectionLmsLog(this.stream, this.auxStream, this.alpha, this.beta);
        }
        return Math.log(GammaAcceptanceRejectionGen.acceptanceRejection(this.stream, this.auxStream, this.alpha, this.beta, this.gamma, this.gen, this.b, this.s, this.ss, this.d, this.r, this.q0, this.c, this.si));
    }

    public static double nextDoubleLog(RandomStream s, RandomStream aux, double alpha, double lambda) {
        boolean gen = false;
        double s_ = 0.0;
        double ss = 0.0;
        double d = 0.0;
        double q0 = 0.0;
        double r = 0.0;
        double c = 0.0;
        double si = 0.0;
        double b = 0.0;
        if (alpha < 0.1) {
            return GammaAcceptanceRejectionGen.acceptanceRejectionLmsLog(s, aux, alpha, 1.0 / lambda);
        }
        return Math.log(GammaAcceptanceRejectionGen.nextDouble(s, aux, alpha, lambda));
    }

    public static double nextDoubleLog(RandomStream s, double alpha, double lambda) {
        return GammaAcceptanceRejectionGen.nextDoubleLog(s, s, alpha, lambda);
    }

    private static double acceptanceRejection(RandomStream stream, RandomStream auxStream, double alpha, double beta, double gamma, int gen, double b, double s, double ss, double d, double r, double q0, double c, double si) {
        double X;
        block0 : switch (gen) {
            case 0: {
                while (true) {
                    double p = b * stream.nextDouble();
                    stream = auxStream;
                    if (p <= 1.0) {
                        X = Math.exp(Math.log(p) / alpha);
                        if (!(Math.log(stream.nextDouble()) <= -X)) continue;
                        break block0;
                    }
                    X = -Math.log((b - p) / alpha);
                    if (Math.log(stream.nextDouble()) <= (alpha - 1.0) * Math.log(X)) break;
                }
                break;
            }
            case 1: {
                double w;
                double sign_U;
                double E;
                double q;
                double v;
                double U;
                double t = NormalDist.inverseF01(stream.nextDouble());
                stream = auxStream;
                double x = s + 0.5 * t;
                X = x * x;
                if (t >= 0.0 || d * (U = stream.nextDouble()) <= t * t * t) break;
                if (x > 0.0) {
                    v = t / (s + s);
                    q = Math.abs(v) > 0.25 ? q0 - s * t + 0.25 * t * t + (ss + ss) * Math.log(1.0 + v) : q0 + 0.5 * t * t * ((((((((0.104089866 * v + -0.112750886) * v + 0.11036831) * v + -0.124385581) * v + 0.142873973) * v + -0.166677482) * v + 0.199999867) * v + -0.249999949) * v + 0.333333333) * v;
                    if (Math.log(1.0 - U) <= q) break;
                }
                do {
                    E = -Math.log(stream.nextDouble());
                    U = stream.nextDouble();
                } while ((t = b + E * si * (sign_U = (U = U + U - 1.0) > 0.0 ? 1.0 : -1.0)) <= -0.71874483771719 || (q = Math.abs(v = t / (s + s)) > 0.25 ? q0 - s * t + 0.25 * t * t + (ss + ss) * Math.log(1.0 + v) : q0 + 0.5 * t * t * ((((((((0.104089866 * v + -0.112750886) * v + 0.11036831) * v + -0.124385581) * v + 0.142873973) * v + -0.166677482) * v + 0.199999867) * v + -0.249999949) * v + 0.333333333) * v) <= 0.0 || !(c * U * sign_U <= (w = q > 0.5 ? Math.exp(q) - 1.0 : ((((((2.47453E-4 * q + 0.001353826) * q + 0.008345522) * q + 0.041664508) * q + 0.166666848) * q + 0.499999994) * q + 1.0) * q) * Math.exp(E - 0.5 * t * t)));
                x = s + 0.5 * t;
                X = x * x;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return gamma + beta * X;
    }

    private static double acceptanceRejectionLms(RandomStream stream, RandomStream auxStream, double alpha, double scale) {
        return Math.exp(GammaAcceptanceRejectionGen.acceptanceRejectionLmsLog(stream, auxStream, alpha, scale));
    }

    private static double acceptanceRejectionLmsLog(RandomStream stream, RandomStream auxStream, double alpha, double scale) {
        double lambda = 1.0 / alpha - 1.0;
        double w = alpha / Math.E / (1.0 - alpha);
        double r = 1.0 / (1.0 + w);
        double c = 1.0 / Gamma.gamma(alpha + 1.0);
        double u = stream.nextDouble();
        double z = 0.0;
        double Z = 0.0;
        while (true) {
            if (GammaAcceptanceRejectionGen.functionHLms(z = u <= r ? -Math.log(u / r) : Math.log(auxStream.nextDouble()) / lambda, alpha, c) / GammaAcceptanceRejectionGen.functionEtaLms(z, alpha, lambda, w, c) > auxStream.nextDouble()) break;
            u = auxStream.nextDouble();
        }
        Z = z;
        return Math.log(scale) - Z / alpha;
    }

    private static double functionHLms(double z, double alpha, double c) {
        return c * Math.exp(-z - Math.exp(-z / alpha));
    }

    private static double functionEtaLms(double z, double alpha, double lambda, double w, double c) {
        if (z >= 0.0) {
            return c * Math.exp(-z);
        }
        return c * w * lambda * Math.exp(lambda * z);
    }

    private void init() {
        if (this.alpha < 1.0) {
            this.gen = 0;
            this.b = 1.0 + 0.36788794412 * this.alpha;
        } else {
            this.gen = 1;
            this.ss = this.alpha - 0.5;
            this.s = Math.sqrt(this.ss);
            this.d = 5.656854249 - 12.0 * this.s;
            this.r = 1.0 / this.alpha;
            this.q0 = ((((((((1.71032E-4 * this.r + -4.701849E-4) * this.r + 6.053049E-4) * this.r + 3.340332E-4) * this.r + -3.349403E-4) * this.r + 0.0015746717) * this.r + 0.0079849875) * this.r + 0.0208333723) * this.r + 0.0416666664) * this.r;
            if (this.alpha > 3.686) {
                if (this.alpha > 13.022) {
                    this.b = 1.77;
                    this.si = 0.75;
                    this.c = 0.1515 / this.s;
                } else {
                    this.b = 1.654 + 0.0076 * this.ss;
                    this.si = 1.68 / this.s + 0.275;
                    this.c = 0.062 / this.s + 0.024;
                }
            } else {
                this.b = 0.463 + this.s - 0.178 * this.ss;
                this.si = 1.235;
                this.c = 0.195 / this.s - 0.079 + 0.016 * this.s;
            }
        }
    }
}

