/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.matrix;

import cern.colt.matrix.DoubleMatrix2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import umontreal.ssj.stat.StatProbe;
import umontreal.ssj.stat.matrix.MatrixOfObservationListener;

public class MatrixOfStatProbes<E extends StatProbe>
implements Cloneable,
Iterable<E> {
    private List<MatrixOfObservationListener> listeners = new ArrayList<MatrixOfObservationListener>();
    protected boolean collect = true;
    protected boolean broadcast = false;
    protected String name;
    private E[] probes;
    private int numRows;
    private int numColumns;
    private int modCount = 0;

    public MatrixOfStatProbes(int numRows, int numColumns) {
        this.createProbes(numRows, numColumns);
    }

    public MatrixOfStatProbes(String name, int numRows, int numColumns) {
        this.name = name;
        this.createProbes(numRows, numColumns);
    }

    private void createProbes(int numRows, int numColumns) {
        if (numRows < 0) {
            throw new NegativeArraySizeException("The number of rows must not be negative");
        }
        if (numColumns < 0) {
            throw new NegativeArraySizeException("The number of columns must not be negative");
        }
        this.numRows = numRows;
        this.numColumns = numColumns;
        int length = numRows * numColumns;
        this.probes = new StatProbe[length];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int rows() {
        return this.numRows;
    }

    public int columns() {
        return this.numColumns;
    }

    public void setRows(int newRows) {
        if (newRows < 0) {
            throw new NegativeArraySizeException("The given number of rows is negative");
        }
        if (this.rows() == newRows) {
            return;
        }
        StatProbe[] newProbes = new StatProbe[newRows * this.columns()];
        int m = Math.min(this.rows(), newRows);
        System.arraycopy(this.probes, 0, newProbes, 0, m * this.columns());
        this.probes = newProbes;
        this.numRows = newRows;
        ++this.modCount;
    }

    public void setColumns(int newColumns) {
        if (newColumns < 0) {
            throw new IllegalArgumentException("The given number of columns is negative");
        }
        if (this.columns() == newColumns) {
            return;
        }
        StatProbe[] newProbes = new StatProbe[this.rows() * newColumns];
        int m = Math.min(this.columns(), newColumns);
        for (int r = 0; r < this.rows(); ++r) {
            System.arraycopy(this.probes, this.columns() * r, newProbes, newColumns * r, m);
        }
        this.probes = newProbes;
        this.numColumns = newColumns;
        ++this.modCount;
    }

    public E get(int r, int c) {
        if (r < 0 || r >= this.numRows) {
            throw new ArrayIndexOutOfBoundsException("Row index out of bounds: " + r);
        }
        if (c < 0 || c >= this.numColumns) {
            throw new ArrayIndexOutOfBoundsException("Column index out of bounds: " + c);
        }
        return this.probes[this.numColumns * r + c];
    }

    public void set(int r, int c, E probe) {
        if (r < 0 || r >= this.numRows) {
            throw new ArrayIndexOutOfBoundsException("Row index out of bounds: " + r);
        }
        if (c < 0 || c >= this.numColumns) {
            throw new ArrayIndexOutOfBoundsException("Column index out of bounds: " + c);
        }
        this.probes[this.numColumns * r + c] = probe;
        ++this.modCount;
    }

    public void init() {
        int rows = this.rows();
        int columns = this.columns();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                ((StatProbe)this.get(r, c)).init();
            }
        }
    }

    public void sum(DoubleMatrix2D m) {
        if (m.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + m.rows());
        }
        if (m.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + m.columns());
        }
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                E probe = this.get(r, c);
                m.setQuick(r, c, probe == null ? Double.NaN : ((StatProbe)probe).sum());
            }
        }
    }

    public void average(DoubleMatrix2D m) {
        if (m.rows() != this.rows()) {
            throw new IllegalArgumentException("Invalid number of rows in the given matrix: required " + this.rows() + " but found " + m.rows());
        }
        if (m.columns() != this.columns()) {
            throw new IllegalArgumentException("Invalid number of columns in the given matrix: required " + this.columns() + " but found " + m.columns());
        }
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                E probe = this.get(r, c);
                m.setQuick(r, c, probe == null ? Double.NaN : ((StatProbe)probe).average());
            }
        }
    }

    public boolean isCollecting() {
        return this.collect;
    }

    public void setCollecting(boolean c) {
        this.collect = c;
    }

    public boolean isBroadcasting() {
        return this.broadcast;
    }

    public void setBroadcasting(boolean b) {
        this.broadcast = b;
    }

    public void addMatrixOfObservationListener(MatrixOfObservationListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeMatrixOfObservationListener(MatrixOfObservationListener l) {
        this.listeners.remove(l);
    }

    public void clearMatrixOfObservationListeners() {
        this.listeners.clear();
    }

    public void notifyListeners(DoubleMatrix2D x) {
        if (!this.broadcast) {
            return;
        }
        int nl = this.listeners.size();
        for (int i = 0; i < nl; ++i) {
            this.listeners.get(i).newMatrixOfObservations(this, x);
        }
    }

    public List<E> viewRow(int r) {
        return new MyList(this, ListType.ROW, r);
    }

    public List<E> viewColumn(int c) {
        return new MyList(this, ListType.COLUMN, c);
    }

    public String rowReport(int r) {
        return StatProbe.report(this.getName(), this.viewRow(r));
    }

    public String columnReport(int c) {
        return StatProbe.report(this.getName(), this.viewColumn(c));
    }

    public MatrixOfStatProbes<E> clone() {
        MatrixOfStatProbes sm;
        try {
            sm = (MatrixOfStatProbes)super.clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("CloneNotSupportedException for a class implementing Cloneable");
        }
        if (this.probes != null) {
            sm.probes = (StatProbe[])this.probes.clone();
        }
        return sm;
    }

    @Override
    public Iterator<E> iterator() {
        return new MyIterator();
    }

    private static class MyList<E extends StatProbe>
    extends AbstractList<E>
    implements RandomAccess {
        private MatrixOfStatProbes<E> matrix;
        private ListType type;
        private int index;

        public MyList(MatrixOfStatProbes<E> matrix, ListType type, int index) {
            this.matrix = matrix;
            this.type = type;
            this.index = index;
        }

        @Override
        public E get(int index) {
            if (this.type == ListType.ROW) {
                return this.matrix.get(this.index, index);
            }
            return this.matrix.get(index, this.index);
        }

        @Override
        public int size() {
            if (this.type == ListType.ROW) {
                return ((MatrixOfStatProbes)this.matrix).numColumns;
            }
            return ((MatrixOfStatProbes)this.matrix).numRows;
        }
    }

    private class MyIterator
    implements Iterator<E> {
        private int index = 0;
        private int expectedModCount = MatrixOfStatProbes.access$000(MatrixOfStatProbes.this);

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            if (MatrixOfStatProbes.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.index < MatrixOfStatProbes.this.probes.length - 1;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return MatrixOfStatProbes.this.probes[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can not remove an element in a matrix");
        }
    }

    private static enum ListType {
        ROW,
        COLUMN;

    }
}

