/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.algorithms.optimization.NegativeDifferentiableFunction;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.StartDistanceForecaster;
import de.jstacs.classifier.scoringFunctionBased.OptimizableFunction;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.EmptySampleException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.motifDiscovery.MotifDiscovererToolBox;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.motifDiscovery.history.History;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.ScoringFunction;
import de.jstacs.scoringFunctions.mix.motifSearch.HiddenMotifsMixture;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.SafeOutputStream;
import java.io.OutputStream;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutableMotifDiscovererToolbox
extends MotifDiscovererToolBox {
    public static Sequence enumerate(Sample[] data, ScoringFunction[] funs, int classIndex, int motifIndex, double weight, OptimizableFunction opt, OutputStream out) throws Exception {
        HiddenMotifsMixture hmm = (HiddenMotifsMixture)funs[classIndex];
        int len = hmm.getMotifLength(motifIndex);
        DiscreteSequenceEnumerator si = new DiscreteSequenceEnumerator(funs[classIndex].getAlphabetContainer(), len, true);
        Sequence bestSeq = null;
        double best = Double.NEGATIVE_INFINITY;
        double[] weights = new double[]{weight};
        Sample s = null;
        while (si.hasMoreElements()) {
            Sequence seq = si.nextElement();
            try {
                s = new Sample(null, seq);
            }
            catch (IllegalArgumentException doesNotHappen) {
            }
            catch (EmptySampleException doesNotHappen) {
                // empty catch block
            }
            hmm.initializeHiddenUniformly();
            hmm.initializeMotif(motifIndex, s, weights);
            hmm.adjustHiddenParameters(data[classIndex], null);
            opt.reset(funs);
            double[] pars = opt.getParameters(OptimizableFunction.KindOfParameter.PLUGIN);
            double curr = opt.evaluateFunction(pars);
            out.write((seq + "\t" + curr + "\n").getBytes());
            if (!(curr > best)) continue;
            best = curr;
            bestSeq = seq;
        }
        out.write(("best: " + bestSeq + " " + best + "\n").getBytes());
        hmm.initializeHiddenUniformly();
        hmm.initializeMotif(motifIndex, new Sample(null, bestSeq), weights);
        hmm.adjustHiddenParameters(data[classIndex], null);
        return bestSeq;
    }

    public static ComparableElement<double[], Double>[] getSortedInitialParameters(Sample[] data, ScoringFunction[] funs, InitMethodForScoringFunction[] init, OptimizableFunction opt, int n, SafeOutputStream stream) throws Exception {
        Object[] erg = new ComparableElement[n];
        for (int i = 0; i < n; ++i) {
            block5: for (int j = 0; j < funs.length; ++j) {
                switch (init[j]) {
                    case PLUG_IN: {
                        funs[j].initializeFunction(j, false, data, null);
                        continue block5;
                    }
                    case RANDOMLY: {
                        funs[j].initializeFunctionRandomly(false);
                        continue block5;
                    }
                }
            }
            opt.reset(funs);
            double[] params = opt.getParameters(OptimizableFunction.KindOfParameter.PLUGIN);
            double c = opt.evaluateFunction(params);
            stream.writeln(i + "\t" + c);
            erg[i] = new ComparableElement<double[], Double>(params, c);
        }
        Arrays.sort(erg);
        stream.writeln("[" + ((ComparableElement)erg[0]).getWeight() + " .. " + ((ComparableElement)erg[n - 1]).getWeight() + "]");
        return erg;
    }

    public static int[][] createMinimalNewLengthArray(ScoringFunction[] funs) {
        int[][] minimalNewLength = new int[funs.length][];
        for (int j = 0; j < funs.length; ++j) {
            if (!(funs[j] instanceof MutableMotifDiscoverer)) continue;
            MutableMotifDiscoverer disc = (MutableMotifDiscoverer)((Object)funs[j]);
            minimalNewLength[j] = new int[disc.getNumberOfMotifs()];
            for (int i = 0; i < minimalNewLength[j].length; ++i) {
                minimalNewLength[j][i] = disc.getMotifLength(i);
            }
        }
        return minimalNewLength;
    }

    public static History[][] createHistoryArray(ScoringFunction[] funs, History template) throws CloneNotSupportedException {
        History[][] history = new History[funs.length][];
        for (int j = 0; j < funs.length; ++j) {
            if (!(funs[j] instanceof MutableMotifDiscoverer)) continue;
            history[j] = new History[((MutableMotifDiscoverer)((Object)funs[j])).getNumberOfMotifs()];
            for (int i = 0; i < history[j].length; ++i) {
                history[j][i] = template.clone();
            }
        }
        return history;
    }

    public static void clearHistoryArray(History[][] history) {
        for (int j = 0; j < history.length; ++j) {
            if (history[j] == null) continue;
            for (int i = 0; i < history[j].length; ++i) {
                history[j][i].clear();
            }
        }
    }

    public static double[][] optimize(ScoringFunction[] funs, OptimizableFunction opt, byte algorithm, double eps, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, boolean breakOnChanged, History template, OptimizableFunction.KindOfParameter plugIn) throws Exception {
        return MutableMotifDiscovererToolbox.optimize(funs, opt, algorithm, eps, linEps, startDistance, out, breakOnChanged, MutableMotifDiscovererToolbox.createHistoryArray(funs, template), MutableMotifDiscovererToolbox.createMinimalNewLengthArray(funs), plugIn);
    }

    public static double[][] optimize(ScoringFunction[] funs, OptimizableFunction opt, byte algorithm, double eps, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, boolean breakOnChanged, History[][] hist, int[][] minimalNewLength, OptimizableFunction.KindOfParameter plugIn) throws Exception {
        NegativeDifferentiableFunction neg = new NegativeDifferentiableFunction(opt);
        ScoringFunction[] best = null;
        double[] classParams = null;
        Sample[] data = opt.getData();
        double[][] weights = opt.getSequenceWeights();
        double bestVal = Double.NEGATIVE_INFINITY;
        do {
            opt.reset(funs);
            startDistance.reset();
            double[] params = opt.getParameters(plugIn);
            plugIn = OptimizableFunction.KindOfParameter.LAST;
            Optimizer.optimize(algorithm, neg, params, Optimizer.TerminationCondition.SMALL_DIFFERENCE_OF_FUNCTION_EVALUATIONS, eps, linEps, startDistance, out);
            double current = opt.evaluateFunction(params);
            if (!(current > bestVal)) continue;
            best = null;
            System.gc();
            best = (ScoringFunction[])ArrayHandler.clone((Cloneable[])funs);
            bestVal = current;
            classParams = opt.getClassParams(params);
        } while (MutableMotifDiscovererToolbox.doHeuristicSteps(funs, data, weights, opt, out, breakOnChanged, hist, minimalNewLength));
        for (int k = 0; k < funs.length; ++k) {
            funs[k] = best[k];
        }
        return new double[][]{{bestVal}, classParams};
    }

    public static boolean doHeuristicSteps(ScoringFunction[] funs, Sample[] data, double[][] weights, OptimizableFunction opt, SafeOutputStream out, boolean breakOnChanged, History[][] hist, int[][] minimalNewLength) throws Exception {
        boolean changed = false;
        for (int k = 0; !(k >= funs.length || changed && breakOnChanged); ++k) {
            double normOld;
            NormalizableScoringFunction nsf;
            if (!(funs[k] instanceof MutableMotifDiscoverer)) continue;
            out.writeln("MutableMotifDiscoverer " + k + ":\n" + funs[k].toString());
            if (funs[k] instanceof NormalizableScoringFunction) {
                nsf = (NormalizableScoringFunction)funs[k];
                normOld = nsf.getNormalizationConstant();
            } else {
                nsf = null;
                normOld = -1.0;
            }
            MutableMotifDiscoverer currMD = (MutableMotifDiscoverer)((Object)funs[k]);
            int numMotifs = currMD.getNumberOfMotifs();
            boolean changedThisOne = false;
            for (int l = 0; l < numMotifs; ++l) {
                changedThisOne |= MutableMotifDiscovererToolbox.modify(currMD, k, l, data, weights, hist[k][l], minimalNewLength[k][l], out);
            }
            if (!changedThisOne) continue;
            changed = true;
            if (nsf == null) continue;
            double normNew = nsf.getNormalizationConstant();
            opt.addTermToClassParameter(k, Math.log(normOld / normNew));
        }
        return changed;
    }

    private static boolean modify(MutableMotifDiscoverer md, int clazz, int motif, Sample[] data, double[][] weights, History hist, int minimalNewLength, SafeOutputStream out) throws Exception {
        boolean modified = false;
        int[] notSignif = md.determineNotSignificantPositionsFor(motif, data, weights, clazz);
        int sum = notSignif[0] + notSignif[1];
        int ml = md.getMotifLength(motif);
        int[] modification = new int[2];
        if (sum > 0) {
            if (sum < ml) {
                modification[0] = notSignif[0] > notSignif[1] ? notSignif[0] : -notSignif[1];
                modification[1] = modification[0];
                if (hist.operationAllowed(modification)) {
                    modified = md.modifyMotif(motif, modification[0], modification[1]);
                }
            }
            if (!modified) {
                if (sum < ml) {
                    modification[0] = notSignif[0];
                    modification[1] = -notSignif[1];
                } else {
                    modification[0] = 0;
                    modification[1] = 1 - md.getMotifLength(motif);
                }
                if (modification[0] != modification[1] && hist.operationAllowed(modification)) {
                    modified = md.modifyMotif(motif, modification[0], modification[1]);
                }
            }
        } else {
            if (md.getMotifLength(motif) < minimalNewLength) {
                modification[0] = 0;
                modification[1] = minimalNewLength - md.getMotifLength(motif);
            } else {
                modification[0] = -1;
                modification[1] = 1;
            }
            if (hist.operationAllowed(modification)) {
                modified = md.modifyMotif(motif, modification[0], modification[1]);
            }
        }
        if (modified) {
            hist.operationPerfomed(modification);
            out.writeln("class " + clazz + ": modified motif " + motif + " => " + Arrays.toString(modification));
        }
        return modified;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InitMethodForScoringFunction {
        PLUG_IN,
        RANDOMLY,
        NOTHING;

    }
}

