package de.jstacs.models.discrete.homogeneous.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.AlphabetContainerParameterSet;
import de.jstacs.models.discrete.DGMParameterSet;
import de.jstacs.models.discrete.homogeneous.HomogeneousModel;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

/**
 * This class implements a container for all parameters of any homogeneous model.
 * 
 * @author Jens Keilwagen
 */
public abstract class HomogeneousModelParameterSet extends DGMParameterSet
{
	
	/**
	 * The constructor for the {@link de.jstacs.Storable} interface.
	 * 
	 * @param s
	 *            the StringBuffer
	 * 
	 * @throws NonParsableException
	 *             if the StringBuffer is not parsable
	 */
	protected HomogeneousModelParameterSet( StringBuffer s ) throws NonParsableException
	{
		super( s );
	}

	/**
	 * An empty constructor.
	 * 
	 * @param instanceClass
	 *            the (sub-)class
	 */
	protected HomogeneousModelParameterSet( Class<? extends HomogeneousModel> instanceClass )
	{
		super( instanceClass, true, true );
	}

	/**
	 * The constructor for models, that can handle variable lengths.
	 * 
	 * @param instanceClass
	 *            the (sub-)class
	 * @param alphabet
	 *            the alphabet
	 * @param ess
	 *            the ESS
	 * @param description
	 *            the description
	 * @param order the Markov order of the model
	 * 
	 * @throws Exception
	 *             if something went wrong
	 */
	protected HomogeneousModelParameterSet( Class<? extends HomogeneousModel> instanceClass, AlphabetContainer alphabet, double ess, String description, byte order ) throws Exception
	{
		super( instanceClass, alphabet, ess, description );
		parameters.get( 2 ).setValue( new Byte( order ) );
	}

	protected void loadParameters() throws Exception
	{
		super.loadParameters();
		parameters
				.add( new SimpleParameter(
						DataType.BYTE,
						"order",
						"the order of the model specifies the number of used ancestors of a random variable that are used to determine its propability",
						true, new NumberValidator<Byte>( (byte) 0, Byte.MAX_VALUE ) ) );
	}

	public boolean hasDefaultOrIsSet()
	{
		if( super.hasDefaultOrIsSet() )
		{
			//return getAlphabet().isSimple();
			return ((AlphabetContainerParameterSet) alphabet.getValue()).isSimple();
		}
		else
		{
			return false;
		}
	}
}
