/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.parameters;

/**
 * Interface for a <code>Parameter</code> or <code>ParameterSet</code> that can have multiple values at the same
 * time. This includes methods to loop over all values while preserving the expected behaviour of the methods defined in
 * <code>Parameter</code> respectively <code>ParameterSet</code>.
 * 
 * @author Jan Grau, Jens Keilwagen
 * 
 */
public interface RangeIterator
{
	/**
	 * Switches to the next value in the collection of values in the specified range.
	 * 
	 * @return if the next element exists
	 * @throws ParameterException
	 *             if the next value could not be set
	 */
	public boolean next() throws ParameterException;

	/**
	 * Resets the current value in the collection to the first value.
	 */
	public void resetToFirst();

	/**
	 * Returns the number of values in the collection.
	 * 
	 * @return the number of values
	 */
	public int getNumberOfValues();

	/**
	 * Returns a <code>String</code>-representation of the set of values.
	 * 
	 * @return the representation
	 */
	public String valuesToString();

	/**
	 * Returns true if this range iterator is ranging over a set of values.
	 * 
	 * @return if ranging
	 */
	public boolean isRanged();
}
