/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization;

import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;

public abstract class NumericalDifferentiableFunction
extends DifferentiableFunction {
    protected double eps;

    public NumericalDifferentiableFunction(double epsilon) throws IllegalArgumentException {
        if (epsilon == 0.0) {
            throw new IllegalArgumentException("Epsilon can not be 0.");
        }
        this.eps = epsilon;
    }

    public double[] evaluateGradientOfFunction(double[] x) throws DimensionException, EvaluationException {
        int n = this.getDimensionOfScope();
        if (x == null || x.length != this.getDimensionOfScope()) {
            if (x != null) {
                throw new DimensionException(x.length, n);
            }
            throw new DimensionException(0, n);
        }
        double[] gradient = new double[n];
        double[] y = new double[n];
        System.arraycopy(x, 0, y, 0, n);
        double current = this.evaluateFunction(x);
        int i = 0;
        while (i < n) {
            int n2 = i;
            y[n2] = y[n2] + this.eps;
            gradient[i] = (this.evaluateFunction(y) - current) / this.eps;
            int n3 = i++;
            y[n3] = y[n3] - this.eps;
        }
        return gradient;
    }
}

