/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.utils;

public class PValueComputation {
    public static final double getPValue(double[] sortedScores, double myScore) {
        return 1.0 - (double)PValueComputation.getIndex(sortedScores, myScore, 0) / (double)sortedScores.length;
    }

    public static final double getPValue(double[] sortedScores, double myScore, int start) {
        return 1.0 - (double)PValueComputation.getIndex(sortedScores, myScore, start) / (double)sortedScores.length;
    }

    public static final int getIndex(double[] sortedScores, double myScore) {
        return PValueComputation.getIndex(sortedScores, myScore, 0);
    }

    public static final int getIndex(double[] sortedScores, double myScore, int start) {
        if (start >= sortedScores.length) {
            return sortedScores.length;
        }
        if (start < 0) {
            return 0;
        }
        if (myScore <= sortedScores[start]) {
            return start;
        }
        int end = sortedScores.length;
        do {
            int bound;
            if (sortedScores[bound = start + (end - start) / 2] < myScore) {
                start = bound;
                continue;
            }
            end = bound;
        } while (end - start > 1);
        return end;
    }

    public static final int getBorder(double[] sortedScores, double pValue) {
        int index = (int)Math.ceil((double)sortedScores.length * (1.0 - pValue));
        if (index == 0 || index == sortedScores.length || sortedScores[index - 1] < sortedScores[index]) {
            return index;
        }
        int start = index;
        int end = sortedScores.length;
        while (end - start > 1) {
            int bound = start + (end - start) / 2;
            if (sortedScores[start] < sortedScores[bound]) {
                end = bound;
                continue;
            }
            start = bound;
        }
        return end;
    }

    public static final double getThreshold(double[] sortedScores, int signIndex) {
        if (signIndex < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (signIndex >= sortedScores.length) {
            return sortedScores[sortedScores.length - 1] * (1.0 + 1.0E-15 * Math.signum(sortedScores[sortedScores.length - 1])) + Double.MIN_VALUE;
        }
        return sortedScores[signIndex];
    }
}

