/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolExtractor
implements Enumeration<String> {
    private String delim;
    private String string;
    private boolean simple;
    private int index;

    public SymbolExtractor(String delim) {
        this(null, delim);
    }

    public SymbolExtractor(String string, String delim) {
        this.delim = delim;
        this.simple = delim == null | delim.length() == 0;
        this.setStringToBeParsed(string);
    }

    public void setStringToBeParsed(String string) {
        this.string = string;
        this.index = this.simple ? 0 : -1;
    }

    public int countElements() {
        if (this.simple) {
            return this.string.length();
        }
        int current = -1;
        int no = 0;
        while (current < this.string.length()) {
            int prev;
            while ((current = this.string.indexOf(this.delim, (prev = current) + 1)) - prev == 1) {
            }
            if (current == -1) {
                return this.string.length() - prev > 1 ? ++no : no;
            }
            ++no;
        }
        return -1;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.simple) {
            return this.index < this.string.length();
        }
        if (this.index < this.string.length()) {
            int prev;
            int current = this.index;
            while ((current = this.string.indexOf(this.delim, (prev = current) + 1)) - prev == 1) {
            }
            this.index = prev;
            if (current == -1) {
                return this.string.length() - prev > 1;
            }
            return true;
        }
        return false;
    }

    @Override
    public String nextElement() {
        int prev;
        if (this.simple) {
            return "" + this.string.charAt(this.index++);
        }
        int current = this.index;
        while ((current = this.string.indexOf(this.delim, (prev = current) + 1)) - prev == 1) {
        }
        this.index = current == -1 ? this.string.length() : current;
        return this.string.substring(prev + 1, this.index);
    }

    public static int filter(String inFile, char ignore, AlphabetContainer con, int minLength, String outFile) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(inFile));
        BufferedWriter w = new BufferedWriter(new FileWriter(outFile));
        String ign = "" + ignore;
        SymbolExtractor se = new SymbolExtractor(con.getDelim());
        int lines = 0;
        while ((line = r.readLine()) != null) {
            if (line.startsWith(ign)) {
                w.write(line);
            } else {
                se.setStringToBeParsed(line);
                int i = 0;
                try {
                    while (se.hasMoreElements()) {
                        con.getCode(i, se.nextElement());
                        ++i;
                    }
                    i -= minLength;
                }
                catch (WrongAlphabetException wae) {
                    i = -1;
                }
                if (i < 0) {
                    w.write(ign + line);
                    ++lines;
                } else {
                    w.write(line);
                }
            }
            w.newLine();
        }
        w.close();
        r.close();
        return lines;
    }
}

