/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.scoringFunctions.directedGraphicalModels.BayesianNetworkScoringFunction;
import de.jstacs.scoringFunctions.directedGraphicalModels.ParameterTree;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.scoringFunctions.mix.motifSearch.DurationScoringFunction;

public class MutableMarkovModelScoringFunction
extends BayesianNetworkScoringFunction
implements Mutable {
    private static int numSamples = 10000;
    private DurationScoringFunction lengthPenalty;
    private static final String XML_TAG = "MutableMarkovModelScoringFunction";

    public MutableMarkovModelScoringFunction(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, InhomogeneousMarkov structureMeasure) throws Exception {
        super(alphabet, length, ess, plugInParameters, structureMeasure);
    }

    public MutableMarkovModelScoringFunction(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, InhomogeneousMarkov structureMeasure, DurationScoringFunction lengthPenalty) throws Exception {
        this(alphabet, length, ess, plugInParameters, structureMeasure);
        this.lengthPenalty = lengthPenalty;
        if (lengthPenalty != null && !lengthPenalty.isPossible(length)) {
            throw new IllegalArgumentException("This motif length is not possible: " + length);
        }
    }

    public MutableMarkovModelScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    protected void fromXML(StringBuffer source) throws NonParsableException {
        StringBuffer sb = XMLParser.extractForTag(source, XML_TAG);
        this.lengthPenalty = (DurationScoringFunction)XMLParser.extractStorableOrNullForTag(sb, "lengthPenalty");
        super.fromXML(sb);
    }

    public StringBuffer toXML() {
        StringBuffer sb = super.toXML();
        XMLParser.appendStorableOrNullWithTags(sb, this.lengthPenalty, "lengthPenalty");
        XMLParser.addTags(sb, XML_TAG);
        return sb;
    }

    public double getLogPriorTerm() {
        if (this.lengthPenalty != null) {
            return super.getLogPriorTerm() + this.lengthPenalty.getLogScore(this.length);
        }
        return super.getLogPriorTerm();
    }

    public boolean modify(double[] weightsLeft, double[] weightsRight, double[][][][] fillEmptyWithLeft, double[][][][] fillEmptyWithRight, int offsetLeft, int offsetRight) {
        double[][][] fillEmptyWithLeftSel = null;
        double best = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < fillEmptyWithLeft.length; ++i) {
            if (!(weightsLeft[i] > best)) continue;
            fillEmptyWithLeftSel = fillEmptyWithLeft[i];
            best = weightsLeft[i];
        }
        double[][][] fillEmptyWithRightSel = null;
        best = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < fillEmptyWithRight.length; ++i) {
            if (!(weightsRight[i] > best)) continue;
            fillEmptyWithRightSel = fillEmptyWithRight[i];
            best = weightsRight[i];
        }
        this.precomputeNormalization();
        this.normalizeParameters();
        this.precomputeNormalization();
        if (!this.getAlphabetContainer().isSimple()) {
            return false;
        }
        if (offsetLeft == 0 && offsetRight == 0) {
            return true;
        }
        ParameterTree[] backTrees = this.trees;
        int backLength = this.getLength();
        try {
            int indexNew;
            this.length = this.getLength() - offsetLeft + offsetRight;
            if (this.lengthPenalty != null && !this.lengthPenalty.isPossible(this.length)) {
                throw new IllegalArgumentException("This motif length is not possible: " + this.length);
            }
            this.createTrees(new Sample[]{null, null}, new double[][]{null, null});
            int indexOld = 0;
            if (offsetLeft >= 0) {
                indexOld = offsetLeft;
            } else {
                for (indexNew = 0; indexNew < -offsetLeft && indexNew < this.trees.length; ++indexNew) {
                    this.trees[indexNew].fill(fillEmptyWithLeftSel);
                }
            }
            while (indexOld < backTrees.length && indexNew < this.trees.length) {
                this.trees[indexNew].copy(backTrees[indexOld]);
                ++indexNew;
                ++indexOld;
            }
            while (indexNew < this.trees.length) {
                this.trees[indexNew].fill(fillEmptyWithRightSel);
                ++indexNew;
            }
            this.normalizationConstant = null;
            return true;
        }
        catch (Exception e) {
            this.length = backLength;
            this.trees = backTrees;
            this.normalizationConstant = null;
            return false;
        }
    }

    private void normalizeParameters() {
        for (int i = 0; i < this.trees.length; ++i) {
            this.trees[i].normalizeParameters();
        }
    }

    private double klDivergence(double[] p, double[] q) {
        double kl = 0.0;
        for (int i = 0; i < p.length; ++i) {
            kl += p[i] * Math.log(p[i] / q[i]);
        }
        return kl;
    }

    public int[] determineNotSignificantPositions(double samples, double[] weightsLeft, double[] weightsRight, double[][][][] contrastLeft, double[][][][] contrastRight, double sign) {
        int c;
        this.precomputeNormalization();
        this.normalizeParameters();
        this.precomputeNormalization();
        int numLeft = 0;
        boolean insign = true;
        for (c = 0; c < this.trees.length; ++c) {
            boolean bl = insign = !this.testSignificance(samples, c, weightsLeft, contrastLeft, sign);
            if (c != numLeft || !insign) continue;
            ++numLeft;
        }
        System.out.println("-----------------------------");
        int numRight = 0;
        insign = true;
        for (c = 0; c < this.trees.length; ++c) {
            boolean bl = insign = !this.testSignificance(samples, this.trees.length - c - 1, weightsRight, contrastRight, sign);
            if (c != numRight || !insign) continue;
            ++numRight;
        }
        return new int[]{numLeft, numRight};
    }

    private boolean testSignificance(double samples, int treeIdx, double[] weights, double[][][][] contrast, double sign) {
        double kl = 0.0;
        double e = this.ess;
        kl = this.trees[treeIdx].getKLDivergence(weights, contrast);
        double[] kls = new double[numSamples];
        this.trees[treeIdx].drawKLDivergences(kls, weights, contrast, e);
        System.out.print(treeIdx + " ");
        return this.testSign(kls, kl, sign);
    }

    private boolean testSign(double[] kls, double kl, double sign) {
        double num = 0.0;
        for (int i = 0; i < kls.length; ++i) {
            if (!(kls[i] >= kl)) continue;
            num += 1.0;
        }
        System.out.println("kl: " + kl + ": " + num / (double)kls.length + " -> " + (num / (double)kls.length < sign));
        return num / (double)kls.length < sign;
    }
}

