/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.algorithms.optimization.termination;

import de.jstacs.utils.Time;


/**
 * This class implements a {@link TerminationCondition} that stops the optimization if the elapsed time in seconds is
 * greater than a given value.
 * 
 * @author Jens Keilwagen
 *
 * @see Time
 */
public class TimeCondition implements TerminationCondition {

	private double seconds;
	
	/**
	 * This constructor creates an instance that does not allow any further iteration after <code>s</code> seconds
	 * 
	 * @param s the threshold of stopping the optimization (in seconds)
	 */
	public TimeCondition( double s ) {
		if( s < 0 ) {
			throw new IllegalArgumentException( "The seconds have to be noon-negative." );
		}
		this.seconds = s;
	}
	
	public boolean doNextIteration( int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha,
			Time t ) {
		return t.getElapsedTime() < seconds;
	}

}
