/*
 * Decompiled with CFR 0.152.
 */
package latexlet;

import com.sun.javadoc.Doc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.LinkedList;

public abstract class LaTeXlet
implements Taglet {
    private static int count;
    private static String docclass;
    private static String begindoc;
    private static String enddoc;
    private static String preambleTag;
    private static String preambleStart;
    private static String preambleEnd;
    private static String resolutionStart;
    private static String resolutionEnd;
    private static String noams;
    private static int preLength;
    static final String imagePath;
    private byte[] buffer;
    private static Hashtable<String, Hashtable<String, LinkedList<String>>> imageMapper;

    static {
        if (System.getProperty("LaTeXlet.init") == null) {
            System.out.println("*********************************************************************************\n* LaTeXlet is free software: you can redistribute it and/or modify it under the *\n* terms of the GNU General Public License as published by the Free Software     *\n* Foundation, either version 3 of the License, or (at your option) any later    *\n* version.                                                                      *\n*                                                                               *\n* LaTeXlet is distributed in the hope that it will be useful, but WITHOUT ANY   *\n* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR *\n* A PARTICULAR PURPOSE. See the GNU General Public License for more details.    *\n*********************************************************************************");
            System.setProperty("LaTeXlet.init", "true");
        }
        count = 0;
        docclass = "\\documentclass{article}\n";
        begindoc = "\\begin{document}\n\\pagestyle{empty}";
        enddoc = "\n\\end{document}";
        preambleTag = "%preamble";
        preambleStart = "{";
        preambleEnd = "}";
        resolutionStart = "%resolution{";
        resolutionEnd = "}";
        noams = "%noams";
        preLength = preambleTag.length() + preambleStart.length();
        imagePath = "images" + File.separator;
        imageMapper = new Hashtable();
    }

    protected abstract String getImgInfix();

    private String getClassName(Tag tag) {
        String temp = tag.position().file().getName();
        return temp.substring(0, temp.length() - 5);
    }

    protected abstract boolean isOneLine();

    public boolean inConstructor() {
        return true;
    }

    public boolean inField() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    private String getBaseForTag(Tag tag) {
        return this.getBaseForTag(tag.position().file().getAbsolutePath());
    }

    String getBaseForTag(String suff) {
        String base = ConfigurationImpl.getInstance().destDirName;
        base = new File(base).getAbsolutePath();
        String sp = ConfigurationImpl.getInstance().sourcepath;
        String[] sps = sp.split(File.pathSeparator);
        int preL = 0;
        String[] stringArray = sps;
        int n = sps.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (suff.startsWith(s = new File(s).getAbsolutePath()) && s.length() > preL) {
                preL = s.length();
            }
            ++n2;
        }
        suff = suff.substring(preL);
        suff = suff.substring(0, suff.lastIndexOf(File.separator) + 1);
        base = String.valueOf(base) + suff;
        return base;
    }

    private int waitForProcess(Process p, Tag t) throws IOException, InterruptedException {
        StringBuffer buf = new StringBuffer();
        StringBuffer buf2 = new StringBuffer();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader r2 = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String tmp = null;
        String tmp2 = null;
        while ((tmp = r.readLine()) != null || (tmp2 = r2.readLine()) != null) {
            if (tmp != null) {
                buf.append(String.valueOf(tmp) + "\n");
            }
            if (tmp2 == null) continue;
            buf2.append(String.valueOf(tmp2) + "\n");
        }
        int ret = p.waitFor();
        if (ret != 0) {
            System.err.println("##########################");
            System.err.println("Problem in comment on " + t.holder().toString() + " in file " + t.position().file() + ", line " + t.position().line() + " for code:");
            System.err.println(t.text());
            System.err.println("--------------------------");
            if (buf.length() > 0) {
                System.err.println("OUTPUT:");
                System.err.print(buf.toString());
            }
            if (buf2.length() > 0) {
                System.err.println("ERROR:");
                System.err.print(buf2.toString());
            }
            System.err.println("##########################");
        }
        return ret;
    }

    private String[] generateImagesForTags(Tag ... allTags) throws Exception {
        LinkedList<String> images = new LinkedList<String>();
        Tag[] tagArray = allTags;
        int n = allTags.length;
        int n2 = 0;
        while (n2 < n) {
            Tag tag = tagArray[n2];
            String key1 = tag.position().file().getAbsolutePath();
            Hashtable<String, LinkedList<String>> map = imageMapper.get(key1);
            boolean add = map == null;
            String key2 = tag.text();
            LinkedList<String> list = !add ? map.get(key2) : null;
            if (list == null) {
                ++count;
                File workDir = new File(String.valueOf(this.getBaseForTag(tag)) + imagePath);
                if (!workDir.exists()) {
                    workDir.mkdirs();
                }
                File[] before = workDir.listFiles();
                String filepath = String.valueOf(workDir.getAbsolutePath()) + File.separator + "doc.tex";
                File tex = new File(filepath);
                try {
                    PrintWriter wr = new PrintWriter(tex);
                    wr.println(docclass);
                    String[] preTex = this.extractLaTeXAndPreambleAndResolutionFrom(tag);
                    wr.println(preTex[0]);
                    wr.println(begindoc);
                    wr.println(preTex[1]);
                    wr.println(enddoc);
                    wr.close();
                    Process p = Runtime.getRuntime().exec(new String[]{"latex", "-interaction=nonstopmode", "doc.tex"}, null, workDir);
                    this.waitForProcess(p, tag);
                    p = Runtime.getRuntime().exec(new String[]{"dvipng", "-bg", "Transparent", "-T", "tight", "-D", preTex[2] == null ? "130" : preTex[2], "-o", String.valueOf(this.getClassName(tag)) + "_" + this.getImgInfix() + count + "_%d.png", "doc.dvi"}, null, workDir);
                    this.waitForProcess(p, tag);
                    File[] files = workDir.listFiles();
                    if (map == null) {
                        map = new Hashtable();
                        add = true;
                    }
                    list = new LinkedList();
                    int i = 0;
                    while (i < files.length) {
                        String n3 = files[i].getName();
                        String nl = n3.toLowerCase();
                        if (!LaTeXlet.containedIn(files[i], before) && !nl.endsWith(".png")) {
                            files[i].delete();
                        } else if (nl.endsWith(".png") && n3.startsWith(String.valueOf(this.getClassName(tag)) + "_" + this.getImgInfix() + count + "_")) {
                            images.add(n3);
                            list.add(n3);
                        }
                        ++i;
                    }
                    map.put(key2, list);
                    if (add) {
                        imageMapper.put(key1, map);
                    }
                    this.copyForIndex(tag, list, workDir);
                }
                catch (IOException e) {
                    Exception ex = new Exception("Could not write to " + tex.getAbsolutePath() + " for tag \"" + tag.text() + "\": " + e.getMessage());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
            } else {
                images.addAll(list);
            }
            ++n2;
        }
        return images.toArray(new String[0]);
    }

    private void copyForIndex(Tag tag, LinkedList<String> images, File workDir) {
        Tag[] tags = tag.holder().firstSentenceTags();
        int i = 0;
        while (i < tags.length) {
            if (tags[i].kind().equals(tag.kind()) && tags[i].text().equals(tag.text()) && ConfigurationImpl.getInstance() instanceof ConfigurationImpl) {
                ConfigurationImpl ci = ConfigurationImpl.getInstance();
                if (ci.createindex) {
                    File dir;
                    String sp = ci.destDirName;
                    if (ci.splitindex) {
                        sp = String.valueOf(sp) + File.separator + "index-files";
                    }
                    if (!(dir = new File(sp)).exists()) {
                        dir.mkdir();
                    }
                    LaTeXlet.copy(workDir.getAbsolutePath(), String.valueOf(sp) + File.separator + imagePath, images.toArray(new String[0]));
                }
            }
            ++i;
        }
    }

    public static void copy(String from, String to, String[] images) {
        File dir = new File(to);
        File workDir = new File(from);
        if (dir.equals(workDir)) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[10000];
        String[] stringArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            String img = stringArray[n2];
            try {
                int amountRead;
                FileInputStream in = new FileInputStream(String.valueOf(workDir.getAbsolutePath()) + File.separator + img);
                FileOutputStream out = new FileOutputStream(String.valueOf(dir.getAbsolutePath()) + File.separator + img);
                while ((amountRead = in.read(buffer)) > -1) {
                    out.write(buffer, 0, amountRead);
                }
                in.close();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private String[] extractLaTeXAndPreambleAndResolutionFrom(Tag tag) {
        String pre = null;
        StringBuffer texBuf = new StringBuffer();
        String res = null;
        String text = tag.text();
        int start = text.indexOf(resolutionStart);
        if (start > -1) {
            int end = text.indexOf(resolutionEnd, start + 1);
            res = text.substring(start + resolutionStart.length(), end);
            text = String.valueOf(text.substring(0, start)) + text.substring(end + 1);
        }
        start = text.indexOf(noams);
        boolean ams = true;
        if (start > -1) {
            text = String.valueOf(text.substring(0, start)) + text.substring(start + noams.length() + 1);
            ams = false;
        }
        if (text.indexOf(preambleTag) > -1) {
            String aft;
            start = text.indexOf(String.valueOf(preambleTag) + preambleStart);
            int end = this.findEnd(text, start + preLength);
            pre = text.substring(start + preLength, end);
            String bef = text.substring(0, start);
            if (!bef.matches("\\s*")) {
                texBuf.append(this.unescapeString(bef, tag.position()));
            }
            if (!(aft = text.substring(end + 1)).matches("\\s*")) {
                texBuf.append(this.unescapeString(aft, tag.position()));
            }
        } else {
            texBuf.append(this.unescapeString(text, tag.position()));
        }
        StringBuffer buf = new StringBuffer();
        if (ams) {
            buf.append("\\usepackage{amssymb}");
        }
        if (pre != null) {
            buf.append(this.unescapeString(pre, tag.position()));
        }
        return new String[]{buf.toString(), texBuf.toString(), res};
    }

    private String unescapeString(String pr, SourcePosition pos) {
        StringWriter wr = new StringWriter();
        char[] chars = pr.toCharArray();
        boolean esc = false;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\\') {
                if (esc) {
                    wr.write("\\");
                    esc = false;
                } else {
                    esc = true;
                }
            } else if (esc) {
                if (chars[i] == 'n') {
                    wr.write("\n");
                } else if (chars[i] == 'r') {
                    wr.write("\r");
                } else if (chars[i] == 't') {
                    wr.write("\t");
                } else if (chars[i] == '\"') {
                    wr.write("\"");
                } else if (chars[i] == '\'') {
                    wr.write("'");
                } else if (chars[i] != ' ') {
                    System.err.println("WARNING: Possible unescaped \\ for comment on line " + pos.line() + " of " + pos.file().getName());
                }
            } else {
                wr.write(chars[i]);
            }
            ++i;
        }
        return wr.toString();
    }

    private int findEnd(String text, int start) {
        int open = 1;
        while (open > 0) {
            int s = text.indexOf(preambleStart, ++start);
            int e = text.indexOf(preambleEnd, start);
            if (s > -1 && s < e) {
                ++open;
                start = s;
            } else if (e > -1) {
                --open;
                start = e;
            }
            if (e != -1 || s != -1 || open <= 0) continue;
            throw new RuntimeException("Could not find end of preamble in " + text.substring(start));
        }
        return start;
    }

    private static boolean containedIn(File file, File ... before) {
        File[] fileArray = before;
        int n = before.length;
        int n2 = 0;
        while (n2 < n) {
            File bef = fileArray[n2];
            if (bef.getAbsolutePath().equals(file.getAbsolutePath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString(Tag tag) {
        StringBuffer buf = new StringBuffer();
        if (!this.isInlineTag()) {
            buf.append("<br /><DT><b>LaTeX:</b></DT><br />\n");
        }
        if (!this.isOneLine()) {
            buf.append("<DL><DD>");
        }
        try {
            String[] ar;
            String[] stringArray = ar = this.generateImagesForTags(tag);
            int n = ar.length;
            int n2 = 0;
            while (n2 < n) {
                String text;
                String img = stringArray[n2];
                int idx = (text = this.unescapeString(tag.text(), tag.position())).indexOf("\n");
                text = text.substring(0, idx > -1 ? idx : text.length());
                buf.append("<img style=\"vertical-align:middle\" alt=\"" + text + "\" src=\"" + imagePath + img + "\" />");
                if (ar.length > 1) {
                    buf.append("<br />");
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            buf.append(this.extractLaTeXAndPreambleAndResolutionFrom(tag)[1]);
        }
        if (!this.isOneLine()) {
            buf.append("</DD></DL>");
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    public String toString(Tag[] tags) {
        block11: {
            block10: {
                buf = new StringBuffer();
                if (!this.isInlineTag()) {
                    buf.append("<br /><DT><b>LaTeX:</b></DT><br />\n");
                }
                if (!this.isOneLine()) {
                    buf.append("<DL><DD>");
                }
                if (tags.length >= 1) break block10;
                return "";
            }
            try {
                var7_5 = ar = this.generateImagesForTags(tags);
                var6_7 = ar.length;
                var5_9 = 0;
                while (var5_9 < var6_7) {
                    img = var7_5[var5_9];
                    if (ar.length > 1) {
                        buf.append("<p>");
                    }
                    text = text.substring(0, (idx = (text = this.unescapeString(tags[0].text(), tags[0].position())).indexOf("\n")) > -1 ? idx : text.length());
                    buf.append("<img style=\"vertical-align:middle\" alt=\"" + text + "\" src=\"" + LaTeXlet.imagePath + img + "\" />");
                    if (ar.length > 1) {
                        buf.append("</p>");
                    }
                    ++var5_9;
                }
                break block11;
            }
            catch (Exception e) {
                e.printStackTrace();
                var7_6 = tags;
                var6_8 = tags.length;
                var5_10 = 0;
                ** while (var5_10 < var6_8)
            }
lbl-1000:
            // 1 sources

            {
                t = var7_6[var5_10];
                buf.append(this.extractLaTeXAndPreambleAndResolutionFrom(t)[1]);
                ++var5_10;
                continue;
            }
        }
        if (!this.isOneLine()) {
            buf.append("<br /><br /></DD></DL>");
        }
        return buf.toString();
    }

    private static class MyTagImpl
    implements Tag {
        private Tag original;
        private SourcePosition pos;
        private Doc holder;

        public MyTagImpl(Tag original, SourcePosition pos, Doc holder) {
            this.original = original;
            this.pos = pos;
            this.holder = holder;
        }

        public Tag[] firstSentenceTags() {
            return this.original.firstSentenceTags();
        }

        public Doc holder() {
            return this.holder;
        }

        public Tag[] inlineTags() {
            return this.original.inlineTags();
        }

        public String kind() {
            return this.original.kind();
        }

        public String name() {
            return this.original.name();
        }

        public SourcePosition position() {
            return this.pos;
        }

        public String text() {
            return this.original.text();
        }
    }
}

