/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.DNAAmbPack;
import org.biojava.bio.symbol.DNANoAmbPack;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IndexedNoAmbPack;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.SymbolList;

public class PackingFactory {
    private static final Map packForAlpha = new HashMap();

    public static Packing getPacking(FiniteAlphabet alpha, boolean ambiguity) throws IllegalAlphabetException {
        Packing pack = (Packing)packForAlpha.get(alpha);
        if (pack == null) {
            if (alpha == DNATools.getDNA()) {
                pack = ambiguity ? new DNAAmbPack() : new DNANoAmbPack(DNATools.a());
            } else {
                if (ambiguity) {
                    throw new IllegalAlphabetException();
                }
                pack = new IndexedNoAmbPack(AlphabetManager.getAlphabetIndex(alpha));
            }
        }
        return pack;
    }

    public static int primeWord(SymbolList symList, int wordLength, Packing packing) throws IllegalSymbolException {
        int word = 0;
        for (int i = 0; i < wordLength; ++i) {
            byte p = packing.pack(symList.symbolAt(i + 1));
            word |= p << i * packing.wordSize();
        }
        return word;
    }

    public static int nextWord(SymbolList symList, int word, int offset, int wordLength, Packing packing) throws IllegalSymbolException {
        word >>= packing.wordSize();
        byte p = packing.pack(symList.symbolAt(offset));
        return word |= p << (wordLength - 1) * packing.wordSize();
    }

    public static void binary(long val) {
        for (int i = 63; i >= 0; --i) {
            System.out.print((val >> i & 1L) == 1L ? 1 : 0);
        }
        System.out.println();
    }

    public static void binary(int val) {
        for (int i = 31; i >= 0; --i) {
            System.out.print((val >> i & 1) == 1 ? 1 : 0);
        }
        System.out.println();
    }
}

