/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojavax.ga.Organism;
import org.biojavax.ga.exception.IllegalOrganismException;
import org.biojavax.ga.impl.AbstractPopulation;

public final class SimplePopulation
extends AbstractPopulation {
    private Map orgs = new HashMap();

    public SimplePopulation(String name) {
        super(name);
    }

    public SimplePopulation() {
        this("");
    }

    protected void addOrganismImpl(Organism orgToAdd) throws IllegalOrganismException {
        if (this.orgs.containsKey(orgToAdd.getName())) {
            throw new IllegalOrganismException("All organisms in a population must have a unique name");
        }
        this.orgs.put(orgToAdd.getName(), orgToAdd);
    }

    protected void removeOrganismImpl(Organism orgToRemove) {
        this.orgs.remove(orgToRemove.getName());
    }

    protected void removeAllOrganismsImpl() {
        this.orgs = new HashMap();
    }

    public Organism getOrganismByName(String name) {
        return (Organism)this.orgs.get(name);
    }

    public int size() {
        return this.orgs.size();
    }

    public Iterator organisms() {
        return this.orgs.values().iterator();
    }

    public Set getOrganisms() {
        return new HashSet(this.orgs.values());
    }
}

