/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment;

import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import java.util.Arrays;

public class Alignment {
    protected int startS1;
    protected int startS2;
    protected Sequence s1;
    protected Sequence s2;
    protected int l1;
    protected int l2;
    protected Costs costs;
    protected AffineCosts aCosts;
    protected AlignmentType type;
    private AlignmentAlgorithm algorithm;
    protected double[][][] d;
    private int offDiagonal;

    public Alignment(Costs costs) {
        this(costs, Integer.MAX_VALUE);
    }

    public Alignment(Costs costs, int offDiagonal) {
        this.costs = costs;
        if (costs instanceof AffineCosts) {
            this.aCosts = (AffineCosts)costs;
            this.algorithm = new AffineAlignment();
        } else {
            this.aCosts = null;
            this.algorithm = new SimpleAlgorithm();
        }
        this.offDiagonal = offDiagonal;
    }

    public PairwiseStringAlignment getAlignment(AlignmentType type, Sequence s1, Sequence s2) {
        return this.getAlignment(type, s1, 0, s1.getLength(), s2, 0, s2.getLength());
    }

    public PairwiseStringAlignment getAlignment(AlignmentType type, Sequence s1, int startS1, int endS1, Sequence s2, int startS2, int endS2) {
        this.computeAlignment(type, s1, startS1, endS1, s2, startS2, endS2);
        int[] index = this.getIndex(endS1, endS2);
        return this.getAlignment(index);
    }

    private void printMatrix(Sequence s1, Sequence s2) {
        for (int i = 0; i < this.d.length; ++i) {
            System.out.println("Matrix: " + i);
            System.out.println("-" + s2);
            for (int j = 0; j < this.d[i].length; ++j) {
                if (j == 0) {
                    System.out.print("-");
                } else {
                    System.out.print(s1.toString(j - 1, j));
                }
                System.out.println(" " + Arrays.toString(this.d[i][j]));
            }
        }
    }

    public boolean computeAlignment(AlignmentType type, Sequence s1, Sequence s2) {
        return this.computeAlignment(type, s1, 0, s1.getLength(), s2, 0, s2.getLength());
    }

    public boolean computeAlignment(AlignmentType type, Sequence s1, int startS1, int endS1, Sequence s2, int startS2, int endS2) {
        this.s1 = s1;
        this.startS1 = startS1;
        this.s2 = s2;
        this.startS2 = startS2;
        this.type = type;
        this.l1 = endS1 - startS1;
        this.l2 = endS2 - startS2;
        if (Math.abs(this.l1 - this.l2) > this.offDiagonal) {
            throw new IllegalArgumentException("The number of secondary diagonals must be at least as large as the difference of the lengths, but is " + this.offDiagonal + " < " + Math.abs(this.l1 - this.l2) + ".");
        }
        if (this.d == null || this.d[0].length < this.l1 + 1 || this.d[0][0].length < this.l2 + 1) {
            this.d = new double[this.aCosts == null ? 1 : 3][this.l1 + 1][this.l2 + 1];
        }
        for (int i = 0; i <= this.l1; ++i) {
            int start = Math.max(0, i - this.offDiagonal);
            int h = i + this.offDiagonal;
            int end = h > 0 ? Math.min(this.l2, h) : this.l2;
            this.algorithm.reset(i, 0, start);
            for (int j = start; j <= end; ++j) {
                this.algorithm.compute(i, j);
            }
            if (end == this.l2) continue;
            this.algorithm.reset(i, end + 1, this.l2);
        }
        return true;
    }

    private int[] getIndex(int e1, int e2) {
        int l1 = e1 - this.startS1;
        int l2 = e2 - this.startS2;
        int[] index = new int[]{-1, -1, -1};
        if (this.type == AlignmentType.LOCAL) {
            index[0] = 0;
            for (int i = 0; i <= l1; ++i) {
                int start = Math.max(0, i - this.offDiagonal);
                int h = i + this.offDiagonal;
                int end = h > 0 ? Math.min(l2, h) : l2;
                for (int j = start; j <= end; ++j) {
                    if (index[1] >= 0 && !(this.d[0][i][j] < this.d[0][index[1]][index[2]])) continue;
                    index[1] = i;
                    index[2] = j;
                }
            }
        } else {
            index[1] = l1;
            index[2] = l2;
            index[0] = this.aCosts == null ? 0 : (this.d[1][l1][l2] < this.d[2][l1][l2] && this.d[1][l1][l2] < this.d[0][l1][l2] ? 1 : (this.d[2][l1][l2] < this.d[0][l1][l2] ? 2 : 0));
        }
        return index;
    }

    public double getCost(int end1, int end2) {
        int[] index = this.getIndex(end1, end2);
        return this.d[index[0]][index[1]][index[2]];
    }

    protected PairwiseStringAlignment getAlignment(int[] index) {
        double cost = this.d[index[0]][index[1]][index[2]];
        StringBuffer b1 = new StringBuffer();
        StringBuffer b2 = new StringBuffer();
        AlphabetContainer cont = this.s1.getAlphabetContainer();
        int[] next = (int[])index.clone();
        int startPos = 0;
        int endPos = this.type == AlignmentType.LOCAL ? this.startS1 + index[1] : index[1];
        int numMatches = 0;
        while (true) {
            int k;
            String sym;
            this.algorithm.next(index, next);
            if (next[0] < 0) break;
            int row = next[1] - index[1];
            int column = next[2] - index[2];
            if (row == -1 && column == -1) {
                b1.insert(0, cont.getSymbol(this.startS1 + index[1] - 1, this.s1.discreteVal(this.startS1 + index[1] - 1)));
                b1.insert(0, cont.getDelim());
                b2.insert(0, cont.getSymbol(this.startS2 + index[2] - 1, this.s2.discreteVal(this.startS2 + index[2] - 1)));
                b2.insert(0, cont.getDelim());
                if (this.s1.discreteVal(this.startS1 + index[1] - 1) == this.s2.discreteVal(this.startS2 + index[2] - 1)) {
                    ++numMatches;
                }
            } else if (column == -1) {
                sym = cont.getSymbol(this.startS2 + index[2] - 1, this.s2.discreteVal(this.startS2 + index[2] - 1));
                b2.insert(0, sym);
                b2.insert(0, cont.getDelim());
                for (k = 0; k < sym.length(); ++k) {
                    b1.insert(0, '-');
                }
                b1.insert(0, cont.getDelim());
            } else if (row == -1) {
                sym = cont.getSymbol(this.startS1 + index[1] - 1, this.s1.discreteVal(this.startS1 + index[1] - 1));
                b1.insert(0, sym);
                b1.insert(0, cont.getDelim());
                for (k = 0; k < sym.length(); ++k) {
                    b2.insert(0, '-');
                }
                b2.insert(0, cont.getDelim());
            }
            if (index[2] == this.l2 && column == -1) {
                endPos = this.startS1 + index[1];
            }
            if ((this.type == AlignmentType.LOCAL || index[2] == 1) && row == -1) {
                startPos = this.startS1 + index[1] - 1;
            }
            System.arraycopy(next, 0, index, 0, 3);
        }
        return new PairwiseStringAlignment(b1.toString(), b2.toString(), cost, startPos, endPos, numMatches);
    }

    private class AffineAlignment
    implements AlignmentAlgorithm {
        private AffineAlignment() {
        }

        @Override
        public void compute(int i, int j) {
            this.computeGap1(i, j);
            this.computeGap2(i, j);
            this.computeMatchMisMatch(i, j);
        }

        public byte computeMatchMisMatch(int i, int j) {
            int direction = -99;
            if (i == 0 && j == 0) {
                Alignment.this.d[0][i][j] = 0.0;
            } else if (i == 0 && j > 0) {
                Alignment.this.d[0][i][j] = Alignment.this.d[1][i][j];
                direction = 1;
            } else if (i > 0 && j == 0) {
                Alignment.this.d[0][i][j] = Alignment.this.d[2][i][j];
                direction = 2;
            } else {
                double diag = Alignment.this.d[0][i - 1][j - 1] + Alignment.this.costs.getCostFor(Alignment.this.s1, Alignment.this.s2, Alignment.this.startS1 + i, Alignment.this.startS2 + j);
                double left = Alignment.this.d[1][i][j];
                double top = Alignment.this.d[2][i][j];
                if (diag < left && diag < top) {
                    Alignment.this.d[0][i][j] = diag;
                    direction = 0;
                } else if (left < top) {
                    Alignment.this.d[0][i][j] = left;
                    direction = 1;
                } else {
                    Alignment.this.d[0][i][j] = top;
                    direction = 2;
                }
            }
            if (Alignment.this.type == AlignmentType.LOCAL && 0.0 < Alignment.this.d[0][i][j]) {
                Alignment.this.d[0][i][j] = 0.0;
                direction = -1;
            }
            return (byte)direction;
        }

        public byte computeGap1(int i, int j) {
            byte direction = -100;
            if (j == 0) {
                Alignment.this.d[1][i][j] = Double.POSITIVE_INFINITY;
            } else if (i == 0) {
                if (Alignment.this.type == AlignmentType.LOCAL) {
                    direction = -1;
                    Alignment.this.d[1][i][j] = 0.0;
                } else {
                    direction = 1;
                    Alignment.this.d[1][i][j] = Alignment.this.type == AlignmentType.FREE_SHIFT ? 0.0 : Alignment.this.aCosts.getGapCostsFor(j);
                }
            } else if (Alignment.this.type == AlignmentType.FREE_SHIFT && i == Alignment.this.l1) {
                direction = 0;
                Alignment.this.d[1][i][j] = Alignment.this.d[0][i][j - 1];
            } else {
                double start;
                double elong = Alignment.this.d[1][i][j - 1] + Alignment.this.aCosts.getElongateCosts();
                if (elong < (start = Alignment.this.d[0][i][j - 1] + Alignment.this.aCosts.getGapCostsFor(1))) {
                    Alignment.this.d[1][i][j] = elong;
                    direction = 1;
                } else {
                    Alignment.this.d[1][i][j] = start;
                    direction = 0;
                }
            }
            return direction;
        }

        public byte computeGap2(int i, int j) {
            int direction = -101;
            if (i == 0) {
                Alignment.this.d[2][i][j] = Double.POSITIVE_INFINITY;
            } else if (j == 0) {
                direction = (byte)(Alignment.this.type == AlignmentType.LOCAL ? -1 : 2);
                Alignment.this.d[2][i][j] = Alignment.this.type != AlignmentType.GLOBAL ? 0.0 : Alignment.this.aCosts.getGapCostsFor(i);
            } else if ((Alignment.this.type == AlignmentType.SEMI_GLOBAL || Alignment.this.type == AlignmentType.FREE_SHIFT) && j == Alignment.this.l2) {
                direction = 0;
                Alignment.this.d[2][i][j] = Alignment.this.d[0][i - 1][j];
            } else {
                double start;
                double elong = Alignment.this.d[2][i - 1][j] + Alignment.this.aCosts.getElongateCosts();
                if (elong < (start = Alignment.this.d[0][i - 1][j] + Alignment.this.aCosts.getGapCostsFor(1))) {
                    Alignment.this.d[2][i][j] = elong;
                    direction = 2;
                } else {
                    Alignment.this.d[2][i][j] = start;
                    direction = 0;
                }
            }
            return (byte)direction;
        }

        @Override
        public void next(int[] index, int[] next) {
            switch (index[0]) {
                case 0: {
                    byte b = this.computeMatchMisMatch(index[1], index[2]);
                    if (b < 0) {
                        next[0] = -1;
                        break;
                    }
                    System.arraycopy(index, 0, next, 0, 3);
                    if (b == 0) {
                        next[1] = next[1] - 1;
                        next[2] = next[2] - 1;
                        break;
                    }
                    next[0] = b;
                    break;
                }
                case 1: {
                    byte b = this.computeGap1(index[1], index[2]);
                    if (b < 0) {
                        next[0] = -1;
                        break;
                    }
                    System.arraycopy(index, 0, next, 0, 3);
                    next[2] = next[2] - 1;
                    next[0] = b;
                    break;
                }
                case 2: {
                    byte b = this.computeGap2(index[1], index[2]);
                    if (b < 0) {
                        next[0] = -1;
                        break;
                    }
                    System.arraycopy(index, 0, next, 0, 3);
                    next[1] = next[1] - 1;
                    next[0] = b;
                }
            }
        }

        @Override
        public void reset(int i, int startJ, int endJ) {
            for (int k = 0; k < Alignment.this.d.length; ++k) {
                if (startJ >= 0 && startJ < Alignment.this.d[k][i].length) {
                    Alignment.this.d[k][i][startJ] = Double.POSITIVE_INFINITY;
                }
                if (endJ <= 0 || endJ > Alignment.this.d[k][i].length) continue;
                Alignment.this.d[k][i][endJ - 1] = Double.POSITIVE_INFINITY;
            }
        }
    }

    private class SimpleAlgorithm
    implements AlignmentAlgorithm {
        private SimpleAlgorithm() {
        }

        @Override
        public void compute(int i, int j) {
            this.computeDirection(i, j);
        }

        public byte computeDirection(int i, int j) {
            int direction = -1;
            if (i == 0 && j == 0) {
                Alignment.this.d[0][i][j] = 0.0;
            } else if (i == 0 && j > 0) {
                if (Alignment.this.type != AlignmentType.LOCAL) {
                    direction = 1;
                }
                Alignment.this.d[0][i][j] = Alignment.this.type != AlignmentType.GLOBAL && Alignment.this.type != AlignmentType.SEMI_GLOBAL ? 0.0 : Alignment.this.d[0][i][j - 1] + Alignment.this.costs.getGapCosts();
            } else if (i > 0 && j == 0) {
                if (Alignment.this.type != AlignmentType.LOCAL) {
                    direction = 2;
                }
                Alignment.this.d[0][i][j] = Alignment.this.type != AlignmentType.GLOBAL ? 0.0 : Alignment.this.d[0][i - 1][j] + Alignment.this.costs.getGapCosts();
            } else {
                double diag = Alignment.this.d[0][i - 1][j - 1] + Alignment.this.costs.getCostFor(Alignment.this.s1, Alignment.this.s2, Alignment.this.startS1 + i, Alignment.this.startS2 + j);
                double left = Alignment.this.d[0][i][j - 1];
                double top = Alignment.this.d[0][i - 1][j];
                if (i < Alignment.this.l1 && j < Alignment.this.l2) {
                    top += Alignment.this.costs.getGapCosts();
                    left += Alignment.this.costs.getGapCosts();
                } else {
                    if (Alignment.this.type != AlignmentType.SEMI_GLOBAL && Alignment.this.type != AlignmentType.FREE_SHIFT || j < Alignment.this.l2) {
                        top += Alignment.this.costs.getGapCosts();
                    }
                    if (Alignment.this.type != AlignmentType.FREE_SHIFT || i < Alignment.this.l1) {
                        left += Alignment.this.costs.getGapCosts();
                    }
                }
                if (diag < left && diag < top) {
                    Alignment.this.d[0][i][j] = diag;
                    direction = 0;
                } else if (left < top) {
                    Alignment.this.d[0][i][j] = left;
                    direction = 1;
                } else {
                    Alignment.this.d[0][i][j] = top;
                    direction = 2;
                }
            }
            if (Alignment.this.type == AlignmentType.LOCAL && 0.0 < Alignment.this.d[0][i][j]) {
                Alignment.this.d[0][i][j] = 0.0;
                direction = -1;
            }
            return (byte)direction;
        }

        @Override
        public void reset(int i, int startJ, int endJ) {
            if (startJ >= 0 && startJ < Alignment.this.d[0][i].length) {
                Alignment.this.d[0][i][startJ] = Double.POSITIVE_INFINITY;
            }
            if (endJ > 0 && endJ <= Alignment.this.d[0][i].length) {
                Alignment.this.d[0][i][endJ - 1] = Double.POSITIVE_INFINITY;
            }
        }

        @Override
        public void next(int[] index, int[] next) {
            byte res = this.computeDirection(index[1], index[2]);
            if (res < 0) {
                next[0] = -1;
            } else {
                System.arraycopy(index, 0, next, 0, 3);
                switch (res) {
                    case 0: {
                        next[1] = next[1] - 1;
                        next[2] = next[2] - 1;
                        break;
                    }
                    case 2: {
                        next[1] = next[1] - 1;
                        break;
                    }
                    case 1: {
                        next[2] = next[2] - 1;
                    }
                }
            }
        }
    }

    private static interface AlignmentAlgorithm {
        public void compute(int var1, int var2);

        public void reset(int var1, int var2, int var3);

        public void next(int[] var1, int[] var2);
    }

    public static enum AlignmentType {
        GLOBAL,
        SEMI_GLOBAL,
        FREE_SHIFT,
        LOCAL;

    }
}

