/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased;

import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.data.DataSet;

public abstract class AbstractOptimizableFunction
extends OptimizableFunction {
    protected DataSet[] data;
    protected double[][] weights;
    protected double[] clazz;
    protected double[] logClazz;
    protected double[] sum;
    protected int cl;
    protected boolean norm;
    protected boolean freeParams;

    protected AbstractOptimizableFunction(DataSet[] data, double[][] weights, boolean norm, boolean freeParams) throws IllegalArgumentException {
        this.norm = norm;
        this.freeParams = freeParams;
        this.cl = weights.length;
        this.logClazz = new double[this.cl];
        this.clazz = new double[this.cl];
        this.sum = new double[this.cl + 1];
        this.setDataAndWeights(data, weights);
    }

    @Override
    public void setDataAndWeights(DataSet[] data, double[][] weights) throws IllegalArgumentException {
        if (data.length != this.cl || weights == null || weights.length != this.cl) {
            throw new IllegalArgumentException("The dimension of the data set or weights (array) is not correct.");
        }
        this.data = data;
        this.weights = weights;
        this.sum[this.cl] = 0.0;
        for (int i = 0; i < this.cl; ++i) {
            this.sum[i] = 0.0;
            if (data[i].getNumberOfElements() != weights[i].length) {
                throw new IllegalArgumentException("The dimension of the " + i + "-th weights (array) is not correct.");
            }
            for (int j = 0; j < weights[i].length; ++j) {
                int n = i;
                this.sum[n] = this.sum[n] + weights[i][j];
            }
            int n = this.cl;
            this.sum[n] = this.sum[n] + this.sum[i];
        }
    }

    public abstract void getParameters(OptimizableFunction.KindOfParameter var1, double[] var2) throws Exception;

    @Override
    public final double[] getParameters(OptimizableFunction.KindOfParameter kind) throws Exception {
        double[] temp = new double[this.getDimensionOfScope()];
        this.getParameters(kind, temp);
        return temp;
    }

    @Override
    public DataSet[] getData() {
        return (DataSet[])this.data.clone();
    }

    @Override
    public double[][] getSequenceWeights() {
        double[][] res = new double[this.cl][];
        for (int i = 0; i < this.cl; ++i) {
            res[i] = (double[])this.weights[i].clone();
        }
        return res;
    }
}

