/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.differentiableSequenceScoreBased;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.DoesNothingLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.DataSet;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Arrays;

public abstract class DiffSSBasedOptimizableFunction
extends AbstractMultiThreadedOptimizableFunction {
    protected int[] shortcut;
    protected DifferentiableSequenceScore[][] score;
    protected DoubleList[][] dList;
    protected IntList[][] iList;
    protected LogPrior prior;

    public DiffSSBasedOptimizableFunction(int threads, DifferentiableSequenceScore[] score, DataSet[] data, double[][] weights, LogPrior prior, boolean norm, boolean freeParams) throws IllegalArgumentException {
        super(threads, data, weights, norm, freeParams);
        this.shortcut = new int[this.cl + 1];
        this.shortcut[0] = freeParams ? this.cl - 1 : this.cl;
        this.prior = prior == null ? DoesNothingLogPrior.defaultInstance : prior;
        this.dList = new DoubleList[threads][this.cl];
        this.iList = new IntList[threads][this.cl];
        this.score = new DifferentiableSequenceScore[threads][this.cl];
        for (int i = 0; i < this.cl; ++i) {
            this.score[0][i] = score[i];
            for (int j = 0; j < threads; ++j) {
                this.dList[j][i] = new DoubleList();
                this.iList[j][i] = new IntList();
            }
        }
    }

    public final double[] getClassParams(double[] params) {
        double[] res = new double[this.cl];
        System.arraycopy(params, 0, res, 0, this.shortcut[0]);
        if (this.freeParams) {
            res[this.shortcut[0]] = 0.0;
        }
        return res;
    }

    @Override
    public final int getDimensionOfScope() {
        return this.shortcut[this.shortcut.length - 1];
    }

    @Override
    protected void setThreadIndependentParameters() throws DimensionException {
        if (this.params == null || this.params.length != this.getDimensionOfScope()) {
            if (this.params != null) {
                throw new DimensionException(this.params.length, this.getDimensionOfScope());
            }
            throw new DimensionException(0, this.getDimensionOfScope());
        }
        for (int counter1 = 0; counter1 < this.shortcut[0]; ++counter1) {
            this.logClazz[counter1] = this.params[counter1];
            this.clazz[counter1] = Math.exp(this.logClazz[counter1]);
        }
        if (this.freeParams) {
            this.clazz[this.cl - 1] = Math.exp(this.logClazz[this.cl - 1]);
        }
    }

    @Override
    public void getParameters(OptimizableFunction.KindOfParameter kind, double[] erg) throws Exception {
        switch (kind) {
            case PLUGIN: {
                int i;
                double[] ess = new double[this.score[0].length];
                double discount = 0.0;
                double e = 0.0;
                for (i = 0; i < this.cl; ++i) {
                    if (this.score[0][i] instanceof DifferentiableStatisticalModel) {
                        ess[i] = ((DifferentiableStatisticalModel)this.score[0][i]).getESS();
                    }
                    e += ess[i];
                }
                if (this.freeParams) {
                    discount = this.score[0][this.cl - 1].getInitialClassParam((this.sum[this.cl - 1] + ess[this.cl - 1]) / (this.sum[this.cl] + e));
                }
                for (i = 0; i < this.shortcut[0]; ++i) {
                    erg[i] = this.score[0][i].getInitialClassParam((this.sum[i] + ess[i]) / (this.sum[this.cl] + e)) - discount;
                }
                break;
            }
            case LAST: {
                int i;
                for (i = 0; i < this.shortcut[0]; ++i) {
                    erg[i] = this.logClazz[i];
                }
                break;
            }
            case ZEROS: {
                Arrays.fill(erg, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown kind of parameter");
            }
        }
        for (int i = 0; i < this.cl; ++i) {
            System.arraycopy(this.score[0][i].getCurrentParameterValues(), 0, erg, this.shortcut[i], this.score[0][i].getNumberOfParameters());
        }
    }

    @Override
    protected void setParams(int index) throws DimensionException {
        for (int counter1 = 0; counter1 < this.cl; ++counter1) {
            this.score[index][counter1].setParameters(this.params, this.shortcut[counter1]);
        }
    }

    public final void addTermToClassParameter(int classIndex, double term) {
        if (classIndex < 0 || classIndex >= this.cl) {
            throw new IndexOutOfBoundsException("check the class index");
        }
        if (this.freeParams && classIndex == this.cl - 1) {
            for (int i = 0; i < this.shortcut[0]; ++i) {
                int n = i;
                this.logClazz[n] = this.logClazz[n] - term;
                this.clazz[i] = Math.exp(this.logClazz[i]);
            }
        } else {
            int n = classIndex;
            this.logClazz[n] = this.logClazz[n] + term;
            this.clazz[classIndex] = Math.exp(this.logClazz[classIndex]);
        }
    }

    public abstract void reset(DifferentiableSequenceScore[] var1) throws Exception;

    @Override
    public final void reset() throws Exception {
        this.reset(this.score[0]);
        System.gc();
    }
}

