/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import java.util.Random;

public class PermutedSequence<T>
extends Sequence.RecursiveSequence<T> {
    private static Random r = new Random();
    private int[] permutation;

    public PermutedSequence(Sequence<T> seq) throws WrongAlphabetException {
        super(seq.getAlphabetContainer(), seq);
        if (!seq.getAlphabetContainer().isSimple()) {
            throw new WrongAlphabetException("Alphabet must be simple");
        }
        this.permutation = new int[seq.getLength()];
        for (int i = 0; i < this.permutation.length; ++i) {
            this.permutation[i] = i;
        }
        for (int i = this.permutation.length - 1; i >= 0; --i) {
            int temp = r.nextInt(i + 1);
            int temp2 = this.permutation[i];
            this.permutation[i] = this.permutation[temp];
            this.permutation[temp] = temp2;
        }
    }

    public PermutedSequence(Sequence<T> seq, int[] permutation) throws WrongAlphabetException, Exception {
        super(seq.getAlphabetContainer(), seq);
        if (!seq.getAlphabetContainer().isSimple()) {
            throw new WrongAlphabetException("Alphabet must be simple");
        }
        if (permutation.length != seq.getLength()) {
            throw new Exception("Length of permutation does not match length of sequence");
        }
        this.permutation = (int[])permutation.clone();
    }

    private PermutedSequence(Sequence<T> seq, SequenceAnnotation[] annotation, int[] perm) {
        super(seq.getAlphabetContainer(), annotation, seq);
        this.permutation = perm;
    }

    @Override
    protected int getIndex(int pos) {
        return this.permutation[pos];
    }

    @Override
    public int getLength() {
        return this.permutation.length;
    }

    @Override
    protected PermutedSequence<T> flatCloneWithoutAnnotation() {
        try {
            return new PermutedSequence<T>(this.content, null, this.permutation);
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }
}

