/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Householder {
    public static double decompose(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (dArray3 == null) {
            dArray3 = new double[n2];
        }
        double d = 1.0;
        for (int i = 0; i < n2 && i < n; ++i) {
            int n3;
            double d2 = dArray[i][i];
            double d3 = d2 * d2;
            double d4 = Math.sqrt(d3);
            d2 = d4 != 0.0 ? (d2 /= d4) : 1.0;
            for (int j = i + 1; j < n; ++j) {
                double d5 = dArray[j][i];
                d3 += d5 * d5;
            }
            d3 = Math.sqrt(d3);
            double d6 = Math.sqrt(1.0 / (2.0 * d3 * (d3 + d4)));
            double d7 = d2 * d3;
            dArray2[i] = -d7;
            d *= d7;
            double[] dArray4 = dArray[i];
            int n4 = i;
            dArray4[n4] = dArray4[n4] + d7;
            for (n3 = i; n3 < n; ++n3) {
                double[] dArray5 = dArray[n3];
                int n5 = i;
                dArray5[n5] = dArray5[n5] * d6;
            }
            for (n3 = i + 1; n3 < n2; ++n3) {
                double d8 = 0.0;
                for (int j = i; j < n; ++j) {
                    d8 += dArray[j][i] * dArray[j][n3];
                }
                dArray3[n3] = 2.0 * d8;
            }
            for (n3 = i + 1; n3 < n2; ++n3) {
                for (int j = i; j < n; ++j) {
                    double[] dArray6 = dArray[j];
                    int n6 = n3;
                    dArray6[n6] = dArray6[n6] - dArray[j][i] * dArray3[n3];
                }
            }
        }
        return d;
    }

    public static double decompose(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray2[0].length;
        double d = Householder.decompose(dArray, dArray3, dArray4);
        for (n = 0; n < n4; ++n) {
            dArray2[0][n] = 0.0;
        }
        for (n = 1; n < n2; ++n) {
            System.arraycopy(dArray2[0], 0, dArray2[n], 0, n4);
        }
        for (n = 0; n < n4; ++n) {
            dArray2[n][n] = 1.0;
        }
        Householder.qTimes(dArray, dArray2, false, dArray4);
        for (n = 0; n < n3; ++n) {
            dArray[n3 - 1][n] = 0.0;
        }
        for (n = 1; n < n3 - 1; ++n) {
            System.arraycopy(dArray[n3 - 1], 0, dArray[n], 0, n);
        }
        for (n = n3; n < n2; ++n) {
            System.arraycopy(dArray[n3 - 1], 0, dArray[n], 0, n3);
        }
        for (n = 0; n < n3; ++n) {
            dArray[n][n] = dArray3[n];
        }
        return d;
    }

    public static double decompose(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray[i], 0, dArray3[i], 0, n2);
        }
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n];
        double d = Householder.decompose(dArray3, dArray2, dArray4, dArray5);
        return d;
    }

    public static double[] decompose(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (dArray5 == null) {
            dArray5 = new double[n2];
        }
        if (dArray6 == null) {
            dArray6 = new double[n2];
        }
        double[] dArray7 = new double[]{1.0, 0.0};
        for (int i = 0; i < n2 && i < n; ++i) {
            double d;
            double d2;
            int n3;
            double d3 = dArray[i][i];
            double d4 = dArray2[i][i];
            double d5 = d3 * d3 + d4 * d4;
            double d6 = Math.sqrt(d5);
            if (d6 != 0.0) {
                d3 /= d6;
                d4 /= d6;
            } else {
                d3 = 1.0;
                d4 = 0.0;
            }
            for (int j = i + 1; j < n; ++j) {
                double d7 = dArray[j][i];
                double d8 = dArray2[j][i];
                d5 += d7 * d7 + d8 * d8;
            }
            d5 = Math.sqrt(d5);
            double d9 = Math.sqrt(1.0 / (2.0 * d5 * (d5 + d6)));
            double d10 = d3 * d5;
            double d11 = d4 * d5;
            dArray3[i] = -d10;
            dArray4[i] = -d11;
            d6 = dArray7[0] * d10 - dArray7[1] * d11;
            dArray7[1] = dArray7[0] * d11 + dArray7[1] * d10;
            dArray7[0] = d6;
            double[] dArray8 = dArray[i];
            int n4 = i;
            dArray8[n4] = dArray8[n4] + d10;
            double[] dArray9 = dArray2[i];
            int n5 = i;
            dArray9[n5] = dArray9[n5] + d11;
            for (n3 = i; n3 < n; ++n3) {
                double[] dArray10 = dArray[n3];
                int n6 = i;
                dArray10[n6] = dArray10[n6] * d9;
                double[] dArray11 = dArray2[n3];
                int n7 = i;
                dArray11[n7] = dArray11[n7] * d9;
            }
            for (n3 = i + 1; n3 < n2; ++n3) {
                double d12 = 0.0;
                double d13 = 0.0;
                for (int j = i; j < n; ++j) {
                    d2 = dArray[j][i];
                    d = -dArray2[j][i];
                    double d14 = dArray[j][n3];
                    double d15 = dArray2[j][n3];
                    d12 += d2 * d14 - d * d15;
                    d13 += d * d14 + d2 * d15;
                }
                dArray5[n3] = 2.0 * d12;
                dArray6[n3] = 2.0 * d13;
            }
            for (n3 = i + 1; n3 < n2; ++n3) {
                for (int j = i; j < n; ++j) {
                    double d16 = dArray[j][i];
                    double d17 = dArray2[j][i];
                    d2 = dArray5[n3];
                    d = dArray6[n3];
                    double[] dArray12 = dArray[j];
                    int n8 = n3;
                    dArray12[n8] = dArray12[n8] - (d16 * d2 - d17 * d);
                    double[] dArray13 = dArray2[j];
                    int n9 = n3;
                    dArray13[n9] = dArray13[n9] - (d17 * d2 + d16 * d);
                }
            }
        }
        return dArray7;
    }

    public static double[] decompose(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray3[0].length;
        double[] dArray9 = Householder.decompose(dArray, dArray2, dArray5, dArray6, dArray7, dArray8);
        for (n = 0; n < n4; ++n) {
            dArray3[0][n] = 0.0;
        }
        System.arraycopy(dArray3[0], 0, dArray4[0], 0, n4);
        for (n = 1; n < n2; ++n) {
            System.arraycopy(dArray3[0], 0, dArray3[n], 0, n4);
            System.arraycopy(dArray4[0], 0, dArray4[n], 0, n4);
        }
        for (n = 0; n < n4; ++n) {
            dArray3[n][n] = 1.0;
        }
        Householder.qTimes(dArray, dArray2, dArray3, dArray4, false, dArray7, dArray8);
        for (n = 0; n < n3; ++n) {
            dArray[n3 - 1][n] = 0.0;
        }
        System.arraycopy(dArray[n3 - 1], 0, dArray2[n3 - 1], 0, n3);
        for (n = 1; n < n3 - 1; ++n) {
            System.arraycopy(dArray[n3 - 1], 0, dArray[n], 0, n);
            System.arraycopy(dArray2[n3 - 1], 0, dArray2[n], 0, n);
        }
        for (n = n3; n < n2; ++n) {
            System.arraycopy(dArray[n3 - 1], 0, dArray[n], 0, n3);
            System.arraycopy(dArray2[n3 - 1], 0, dArray2[n], 0, n3);
        }
        for (n = 0; n < n3; ++n) {
            dArray[n][n] = dArray5[n];
            dArray2[n][n] = dArray6[n];
        }
        return dArray9;
    }

    public static double[] decompose(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, double[][] dArray5, double[][] dArray6) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray[i], 0, dArray5[i], 0, n2);
            System.arraycopy(dArray2[i], 0, dArray6[i], 0, n2);
        }
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        double[] dArray9 = new double[n];
        double[] dArray10 = new double[n];
        double[] dArray11 = Householder.decompose(dArray5, dArray6, dArray3, dArray4, dArray7, dArray8, dArray9, dArray10);
        return dArray11;
    }

    public static void qTimes(double[][] dArray, double[] dArray2, boolean bl) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = bl ? i : n2 - 1 - i;
            double d = 0.0;
            for (n3 = n4; n3 < n; ++n3) {
                d += dArray[n3][n4] * dArray2[n3];
            }
            d *= 2.0;
            for (n3 = n4; n3 < n; ++n3) {
                int n5 = n3;
                dArray2[n5] = dArray2[n5] - dArray[n3][n4] * d;
            }
        }
    }

    public static void qTimes(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, boolean bl) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            double d;
            double d2;
            int n3;
            int n4 = bl ? i : n2 - 1 - i;
            double d3 = 0.0;
            double d4 = 0.0;
            for (n3 = n4; n3 < n; ++n3) {
                d2 = dArray[n3][n4];
                d = -dArray2[n3][n4];
                double d5 = dArray3[n3];
                double d6 = dArray4[n3];
                d3 += d2 * d5 - d * d6;
                d4 += d * d5 + d2 * d6;
            }
            d3 *= 2.0;
            d4 *= 2.0;
            n3 = n4;
            while (n3 < n) {
                d2 = dArray[n3][n4];
                d = dArray2[n3][n4];
                int n5 = n3;
                dArray3[n5] = dArray3[n5] - (d2 * d3 - d * d4);
                int n6 = n3++;
                dArray4[n6] = dArray4[n6] - (d * d3 + d2 * d4);
            }
        }
    }

    public static void qTimes(double[][] dArray, double[][] dArray2, boolean bl, double[] dArray3) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray2[0].length;
        if (dArray3 == null) {
            dArray3 = new double[n3];
        }
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5 = bl ? i : n2 - 1 - i;
            for (n4 = 0; n4 < n3; ++n4) {
                double d = 0.0;
                for (int j = n5; j < n; ++j) {
                    d += dArray[j][n5] * dArray2[j][n4];
                }
                dArray3[n4] = 2.0 * d;
            }
            for (n4 = n5; n4 < n; ++n4) {
                for (int j = 0; j < n3; ++j) {
                    double[] dArray4 = dArray2[n4];
                    int n6 = j;
                    dArray4[n6] = dArray4[n6] - dArray[n4][n5] * dArray3[j];
                }
            }
        }
    }

    public static void qTimes(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4, boolean bl, double[] dArray5, double[] dArray6) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray3[0].length;
        if (dArray5 == null) {
            dArray5 = new double[n3];
        }
        if (dArray6 == null) {
            dArray6 = new double[n3];
        }
        for (int i = 0; i < n2; ++i) {
            double d;
            double d2;
            int n4;
            int n5 = bl ? i : n2 - 1 - i;
            for (n4 = 0; n4 < n3; ++n4) {
                double d3 = 0.0;
                double d4 = 0.0;
                for (int j = n5; j < n; ++j) {
                    d2 = dArray[j][n5];
                    d = -dArray2[j][n5];
                    double d5 = dArray3[j][n4];
                    double d6 = dArray4[j][n4];
                    d3 += d2 * d5 - d * d6;
                    d4 += d * d5 + d2 * d6;
                }
                dArray5[n4] = 2.0 * d3;
                dArray6[n4] = 2.0 * d4;
            }
            for (n4 = n5; n4 < n; ++n4) {
                int n6 = 0;
                while (n6 < n3) {
                    double d7 = dArray[n4][n5];
                    double d8 = dArray2[n4][n5];
                    d2 = dArray5[n6];
                    d = dArray6[n6];
                    double[] dArray7 = dArray3[n4];
                    int n7 = n6;
                    dArray7[n7] = dArray7[n7] - (d7 * d2 - d8 * d);
                    double[] dArray8 = dArray4[n4];
                    int n8 = n6++;
                    dArray8[n8] = dArray8[n8] - (d8 * d2 + d7 * d);
                }
            }
        }
    }
}

