/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;

public class FisherFDist
extends ContinuousDistribution {
    protected int n;
    protected int m;

    public FisherFDist(int n, int m) {
        this.setParams(n, m);
    }

    public double density(double x) {
        return FisherFDist.density(this.n, this.m, x);
    }

    public double cdf(double x) {
        return FisherFDist.cdf(this.n, this.m, this.decPrec, x);
    }

    public double barF(double x) {
        return FisherFDist.barF(this.n, this.m, this.decPrec, x);
    }

    public double inverseF(double u) {
        return FisherFDist.inverseF(this.n, this.m, this.decPrec, u);
    }

    public double getMean() {
        return FisherFDist.getMean(this.n, this.m);
    }

    public double getVariance() {
        return FisherFDist.getVariance(this.n, this.m);
    }

    public double getStandardDeviation() {
        return FisherFDist.getStandardDeviation(this.n, this.m);
    }

    public static double density(int n, int m, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp(Num.lnGamma((double)(n + m) / 2.0) + (double)n / 2.0 * Math.log(n) + (double)m / 2.0 * Math.log(m) + ((double)n - 2.0) / 2.0 * Math.log(x) - (Num.lnGamma((double)n / 2.0) + Num.lnGamma((double)m / 2.0) + (double)(n + m) / 2.0 * Math.log((double)m + (double)n * x)));
    }

    public static double cdf(int n, int m, int d, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        return BetaDist.cdf((double)n / 2.0, (double)m / 2.0, d, (double)n * x / ((double)n * x + (double)m));
    }

    public static double barF(int n, int m, int d, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (x <= 0.0) {
            return 1.0;
        }
        return BetaDist.barF((double)n / 2.0, (double)m / 2.0, d, (double)n * x / ((double)n * x + (double)m));
    }

    public static double inverseF(int n, int m, int d, double u) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u < 0 or u > 1");
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double z = BetaDist.inverseF((double)n / 2.0, (double)m / 2.0, d, u);
        return (double)m * z / ((double)n * (1.0 - z));
    }

    public static double getMean(int n, int m) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (m <= 2) {
            throw new IllegalArgumentException("m <= 2");
        }
        return (double)m / ((double)m - 2.0);
    }

    public static double getVariance(int n, int m) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (m <= 4) {
            throw new IllegalArgumentException("m <= 4");
        }
        return 2.0 * (double)m * (double)m * (double)(m + n - 2) / ((double)n * ((double)m - 2.0) * ((double)m - 2.0) * ((double)m - 4.0));
    }

    public static double getStandardDeviation(int n, int m) {
        return Math.sqrt(FisherFDist.getVariance(n, m));
    }

    public int getN() {
        return this.n;
    }

    public int getM() {
        return this.m;
    }

    public void setParams(int n, int m) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        this.n = n;
        this.m = m;
        this.supportA = 0.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n, this.m};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : n = " + this.n + ", m = " + this.m;
    }
}

